# THIS removes a region in phase space which may have bad or comtaminated
#    data.  The region is defined by limits in E, phi, and theta.  The
#    removed region is refilled using a linear interpolation in phi.

package provide MOments 1.0

proc MOclipData { } {
   global mANS phImG dfImG vBImG vEImG RtoD thBImG thEImG eBImG eEImG

# THIS is the text window for clipping and masking

   set W .moMask.body.list
   if ![winfo exists $W] { MOguiMasks 1 }

# THIS is the number of definition in the window

   set nF [$W index end]

# THE image sizes

   set tS  [expr $mANS(0,NSEN) * $mANS(nE)]
   set ToT [expr $tS * $mANS(Sector)]

# LOOP over the definitions and process the clipping ones

   for { set Q 0 } { $Q < $nF } { incr Q } { 

# READ the line

      set LiNe [$W get $Q]
      scan $LiNe "%s %f %f %f %f %f %f %f" Type eBeg eEnd pBeg pEnd tBeg tEnd pM

      set cA [string match CLIP_A $Type] 
      set cR [string match CLIP_R $Type] 

      if { !$cA && !$cR } { continue }

# COMPUTE masks for the phi, velocity and theta arrays.

# ENERGY clipping is either ABSOLUTE or RELATIVE.  RELATIVE clipping is
#   done using the potential corrected energies.  For this we use the
#   velocity array.  Otherwise we use the read in energies.

      if $cR {
         set vB [expr sqrt($eBeg * $mANS(toV))]
         set vE [expr sqrt($eEnd * $mANS(toV))]

         if { $vBImG(0) < $vEImG(0) } { 
            upvar 0 vBImG V1 ; upvar 0 vEImG V2
         } else { upvar 0 vBImG V2 ; upvar 0 vEImG V1 }
      } else {

         set vB $eBeg
         set vE $eEnd

         if { $eBImG(0) < $eEImG(0) } { 
            upvar 0 eBImG V1 ; upvar 0 eEImG V2
         } else { upvar 0 eBImG V2 ; upvar 0 eEImG V1 }
      }

      for { set I 0 } { $I < $mANS(nE) } { incr I } {
         if { ($vB <= $V1($I)) && ($vE >= $V2($I)) } {
            set vMask($I) 1
         } else { set vMask($I) 0 }
      }

# THETA - array is in radians so limits need to be also 

      set tB [expr $tBeg / $RtoD ]
      set tE [expr $tEnd / $RtoD ]

      if { $thBImG(0) < $thEImG(0) } { 
         upvar 0 thBImG V1 ; upvar 0 thEImG V2
      } else { upvar 0 thBImG V2 ; upvar 0 thEImG V1 }

      for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
         if { ($tB <= $V1($I)) && ($tE >= $V2($I)) } {
            set tMask($I) 1
         } else { set tMask($I) 0 }
      }

# PHASE - array is in degrees before any offset subtraction 

      set pB $pBeg
      set pE $pEnd
      set nP [expr $mANS(nE) * $mANS(Sector)]

      if { $pE >= $pB } { 
         for { set I 0 } { $I < $nP } { incr I } {
           if { ($phImG($I) > $pB) && ($phImG($I) < $pE) } {
               set pMask($I) 1
            } else { set pMask($I) 0 }
         }
      } else {
         for { set I 0 } { $I < $nP } { incr I } {
           if { ($phImG($I) > $pB) || ($phImG($I) < $pE) } {
               set pMask($I) 1
            } else { set pMask($I) 0 }
         }
      }

# NOW the fun part.  

# IF we are clipping out a part of the distribution then Set each 
#    measurement in the df array which is in the region begin clipped to -1.  

      if { $pM < 0.0 } {
         set N 0
         for { set I 0 } { $I < $mANS(Sector) } { incr I } {
            for { set J 0 } { $J < $mANS(0,NSEN) } { incr J } {
               set L [expr $I * $mANS(nE)]
               for { set K 0 } { $K < $mANS(nE) } { incr K ; incr L ; incr N } {
	          if { $pMask($L) && $vMask($K) && $tMask($J) } { 
	               set dfImG($N) -1.0 
	          }
	       }
            }
         }
      } else {
         set pC $pM

# WE are removing all data above some percentage of the min or max value
#   within all phases at a fixed energy/elevation.  This is used to remove
#   charging features.

         for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
            if $tMask($I) { 
               for { set J 0 } { $J < $mANS(nE) } { incr J } {
	          if $vMask($J) { 
                     set MaX -100.0
                     set MiN  1.0e31
                     set N [expr $I * $mANS(nE) + $J]
                     for { set K 0 } { $K < $mANS(Sector) } { incr K } {
	                if { $dfImG($N) > $MaX } { set MaX $dfImG($N) }
	                if { $dfImG($N) < $MiN } { set MiN $dfImG($N) }
	                incr N $tS
                     }
		     if { $MaX > 0.0 } { 
	                set lMx [expr log($MaX)]
		        if { $MiN > 0.0 } { 
		            set lMn [expr log($MiN)]
	                    set RmV [expr exp($lMx - ($lMx - $lMn) * $pC)]
                        } else { set RmV [expr $MaX * $pC] } 
                        set N [expr $I * $mANS(nE) + $J]
                        for { set K 0 } { $K < $mANS(Sector) } { incr K } {
	                   if { $dfImG($N) > $RmV } { set dfImG($N) -1.0 }
	                   incr N $tS
                        }
                     }
                  }
               }
            }
         }
      }

# NOW get rid of the -1's by linearly interpolating in phi across the gaps
#   Do this sensor by sensor and within each sensor energy step by energy
#   step

      set tS  [expr $mANS(0,NSEN) * $mANS(nE)]
      set ToT [expr $tS * $mANS(Sector)]
      set LastS [expr $mANS(Sector) -1 ]

      for { set I 0 } { $I < $tS } { incr I } {
         set EnD $mANS(Sector)
         set J 0
         set K $I

# FIND the first filled sector for this energy/sensor

         while { ($dfImG($K) < 0.0) && ($J < $mANS(Sector)) } { 
	    incr EnD 
	    incr J
	    incr K $tS
            set K [expr $K % $ToT]
         }

# IF there are none do nothing - probably should set them all to 0

         if { $J == $LastS } {
            set K $I
            for { set J 0 } { $J <= $LastS } { incr J ; incr K $tS } {
	       set $dfImG($K) 0.0
	    }
         } else {

# NOW loop over a full spin beginning with the first filled sector

            set L [expr $K % $ToT]
	    set bG $L
            while { $J < $EnD } {
               set gL 0

# CHECK for a gap and get its length if one exists

               while { ($dfImG($L) < 0.0) && ($J < $EnD) } { 
	          incr J 
	          incr K $tS 
	          set L [expr $K % $ToT]
	          incr gL
	       }

# IF there was a gap then fill it

               if { $gL > 0 } {
	          set M [expr $bG + $tS] 
	          if { ($dfImG($L) > 0.0) && ($dfImG($bG) > 0.0) } {
	             set A [expr (log10($dfImG($L) / $dfImG($bG)))/($gL + 1.0)]
	             set Base [expr log10($dfImG($bG))]
	             for { set N 1 } { $N <= $gL } { incr N ; incr M $tS } {
	                set Q [expr $M % $ToT]
		        set dfImG($Q) [expr pow(10., ($Base + double($N) * $A))]
	             }
                  } else {
	             if { ($dfImG($L) <= 0.0) && ($dfImG($bG) <= 0.0) } {
	                set Base 0.0
                     } elseif { $dfImG($L) <= 0.0 } {
	                set Base [expr 0.5 * $dfImG($bG)]
                     } else { set Base [expr 0.5 * $dfImG($L)] }
	             for { set N 1 } { $N <= $gL } { incr N ; incr M $tS } {
	                set Q [expr $M % $ToT]
		        set dfImG($Q) $Base 
	             }
                  }
	       } else { 
	          set bG $L
	          incr J 
	          incr K $tS
	          set L [expr $K % $ToT]
               }
            }
         }
      }
   }
}
