# THIS procedure acquires the all the measurements from a single udf 
#   source for the entire time period over which the moments are being
#   computed.

# IN the procedure:
#   tChk == 0 : measurement time is earlier than the time of the moments
#   tChk == 1 : measurement time is within than the time of the moments
#   tChk == 2 : measurement time is later than the time of the moments

package provide MOments 1.0

proc MOacqUDFSrc { S rV } {
   global SInfo mANS ExDa 

   upvar $rV V

# THIS is the number of sensors being processed under this definition

   set nS [llength $mANS($S,sNum)]

# THIS is the number of the last sensor

   set lS [expr $nS - 1]

# THIS is the acquisition loop.  Acquire the sensors so long as their 
#   center time is within the time of the moments computation.  Forward
#   on the last sensor


   set KeY  $mANS($S,KeY)
   while { $mANS($S,tChk) < 2 } { 
      for { set I 0 } { $I <= $lS } { incr I } {
         if { $I == $lS } { set FwD 1 } else { set FwD 0 }
	 set sN [lindex $mANS($S,sNum) $I]
	 set uN [lindex $mANS($S,sUnit) $I]
         set rS [ReadUDF $KeY 0 1 $sN 0 $FwD 0]
	 if { [lindex [split $rS "|"] 0] == -1 } { 
	     set mANS($S,EOF) 1  
	     return 0
	 }
	 if { $I == 0 } { 
            set mANS($S,bfYr) $ExDa(1,BYR)
	    set mANS($S,efYr) $ExDa(1,EYR)
            set mANS($S,bfDy) $ExDa(1,BDY)
	    set mANS($S,efDy) $ExDa(1,EDY)
            set mANS($S,bfMs) $ExDa(1,BMSEC)
	    set mANS($S,efMs) $ExDa(1,EMSEC)
            set mANS($S,tChk) [MOtimeCheck $S Fr]
         }
         set mANS($S,cV$I) [ConvertToUnits $KeY 0 1 $uN Data] 
         if { ($mANS($S,tChk) == 1) || ($mANS($S,tChk) == 3) } { 
            set V($I) [expr $V($I) + $Fr * $mANS($S,cV$I)] 
	    set Norm($I) [expr $Norm($I) + $Fr]
         }
      }
   }

   if { $Norm(0) > 0 } {
      for { set I 0 } { $I < $nS } { incr I } { 
          set V($I) [expr $V($I) / $Norm($I)] 
      }
   } else {
      for { set I 0 } { $I < $nS } { incr I } { 
         set V($I) $mANS(Bad)
      }
   }

   return $nS
}
