/*  The C equivalent of MOphidfImG. It consists a straight C interface.     */ 
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Velocity Image                                             */
/*     OBJV[2]:  Distribution Function Image                                */
/*     OBJV[3]:  Return array                                               */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TmomentAnsi.h"
#include "TutilAnsi.h"

int PhiDfImg (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   ReaL_8 V, dF, pH; 
   ByTe_4 I, J, K, N, pB, pE;
   int    nE, nS, nT;

   char Index[10];
   char *pName, *dName, *rName;
   int Flg = TCL_LEAVE_ERR_MSG;
   Tcl_Obj *rVO, *rV1;
  
/* MAKE sure that all the IO parameters are present                      */

   if (objc != 4 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: MOphidfImg vImG dfImG Back");
     return TCL_ERROR;
   }

/* GET the global information we'll need                                 */

   Tcl_UpVar(tI, "#0", "mANS", "mAnS", 0);
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "0,NSEN", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nT);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "nE", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nE);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "Sector", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nS);
   }

   pName = Tcl_GetStringFromObj(objv[1], (int *)0);
   dName = Tcl_GetStringFromObj(objv[2], (int *)0);
   rName = Tcl_GetStringFromObj(objv[3], (int *)0);
   rV1 = Tcl_NewObj();

   N = 0;
   pB = 0;
   pE = nE;
   for (K = 0; K < nS; ++K, pB += nE, pE += nE) {
      for (J = 0; J < nT; ++J) {
         for (I = pB; I < pE; ++I, ++N) {
            sprintf(Index, "%d", I);
	    rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
	    Tcl_GetDoubleFromObj (tI, rVO, &pH);
            sprintf(Index, "%d", N);
	    rVO = Tcl_GetVar2Ex(tI, dName, Index, Flg);
	    Tcl_GetDoubleFromObj (tI, rVO, &dF);

            V = pH * dF;

	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      }
   }

   return TCL_OK;
}
