/*  The C equivalent of MOmassintVel. It consists straight C                */
/*  a straight C interface.                                                 */
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Lower band limits                                          */
/*     OBJV[2]:  Upper band limits                                          */
/*     OBJV[3]:  Return integral                                            */
/*     OBJV[4]:  Integral order                                             */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TmomentAnsi.h"
#include "TutilAnsi.h"

int MassIntVel (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   void   *memPtr = NULL; 
   ReaL_8 vL, vH, SgN; 
   ReaL_8 L, H; 
   ReaL_8 *rI; 
   ByTe_4 Bytes, I, J, C;
   int    Order, nE;

   char   Index[10];
   char *lName, *hName;
   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *rVO;
  
/* MAKE sure that all the IO parameters are present                      */

   if (objc != 5 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: MOmassintVel Low High Back Order");
     return TCL_ERROR;
   }

/* GET the inegration order                                              */
 
   Tcl_GetIntFromObj (tI, objv[4], &Order);

/* THIS is the order of the integral.  The plus two comes from the fact  */
/*   that there is a v squared in the integral which came from the       */
/*   conversion to spherical coordinates                                 */

   Order += 2;

/* GET the global information we'll need                                 */

   Tcl_UpVar(tI, "#0", "mANS", "mAnS", 0);
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "nE", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nE);
   }

/* GET the work array memory and put the array data into it              */

   Bytes = sizeof(ReaL_8) * nE;
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }
   rI = (ReaL_8 *)memPtr;

/* GET the input array names                                             */

   lName = Tcl_GetStringFromObj(objv[1], (int *)0);
   hName = Tcl_GetStringFromObj(objv[2], (int *)0);

   rVO = Tcl_GetVar2Ex(tI, lName, "0", Flg);
   Tcl_GetDoubleFromObj (tI, rVO, &vL);
   rVO = Tcl_GetVar2Ex(tI, hName, "0", Flg);
   Tcl_GetDoubleFromObj (tI, rVO, &vH);

/* SET up the sign to use when doing the integration.  This depends on   */
/*   whether we are integrating low to hi or hi to low.                  */
  
   SgN = ( vL < vH ) ? 1.0 : -1.0;
   C = Order + 1;

/* DO the integrations                                                   */

   for ( I = 0; I < nE; ++I) {
      H = 1.0;
      L = 1.0;
      sprintf(Index, "%d", I);
      rVO = Tcl_GetVar2Ex(tI, lName, Index, Flg);
      Tcl_GetDoubleFromObj (tI, rVO, &vL);
      rVO = Tcl_GetVar2Ex(tI, hName, Index, Flg);
      Tcl_GetDoubleFromObj (tI, rVO, &vH);

      for ( J = 0; J < C; ++J) {
         L *= vL;
         H *= vH;
      }
      *rI++ = SgN * (H - L) / (ReaL_8)(C);
   }

/* PUT the data back into the data array                                 */

   CArrayToTcl (tI, objv[3], memPtr, nE, 0, 'D'); 

/* GET rid of the temporary array and return                             */

   free (memPtr);
   return TCL_OK;
}
