/*  The C equivalent of MOlinearintPh. It consists straight C               */
/*  a straight C interface.                                                 */
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Phase Array                                                */
/*     OBJV[2]:  Slope Array                                                */
/*     OBJV[3]:  Intercept Array                                            */
/*     OBJV[4]:  Return integral                                            */
/*     OBJV[5]:  Trig Function to integrate over                            */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TmomentAnsi.h"
#include "TutilAnsi.h"

int LinearIntPh (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   void   *memPtr = NULL; 
   ReaL_8 A, B, V, SgN; 
   ReaL_8 lP, hP, cP, l2P, h2P, l3P, h3P, ConD; 
   ReaL_8 cH, cL, sH, sL; 
   ReaL_8 sH2, sL2, s2H, s2L, s3H, c3H, s3L, c3L; 
   ReaL_8 sH3, sL3, cH3, cL3;
   ReaL_8 TwoPI, RtoD; 
   ReaL_8 *dA, *dB; 
   register ReaL_8  *dP1, *dP2; 
   ByTe_4 Bytes, I, J, K, L, N, pB;
   ByTe_4 ToT;
   int    nE, nS, nT, sP;
   int    Len;
   ByTe_2 trigV = 0;
   ByTe_1 *Trig;

   char Index[10];
   char *pName, *aName, *bName, *rName;
   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *rVO, *rV1;
  
/* MAKE sure that all the IO parameters are present                      */

   if (objc != 6 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: MOlinearintPh Ph S I Back Trig");
     return TCL_ERROR;
   }

/* Set TwoPI and RtoD                                                    */

   TwoPI = 2.0 * 3.14159265358979323846;
   RtoD = 180.0 / 3.14159265358979323846;

/* GET the inegration order                                              */
 
   Trig = Tcl_GetStringFromObj (objv[5], &Len);

/* Get the Trig string to a value                                        */

   if ( strcmp("NONE",Trig) == 0 ) {
      trigV = 0;
   } else if ( strcmp("SIN",Trig) == 0 ) {
      trigV = 1;
   } else if ( strcmp("COS",Trig) == 0 ) {
      trigV = 2;
   } else if ( strcmp("COS2",Trig) == 0 ) {
      trigV = 3;
   } else if ( strcmp("SIN2",Trig) == 0 ) {
      trigV = 4;
   } else if ( strcmp("SINCOS",Trig) == 0 ) {
      trigV = 5;
   } else if ( strcmp("COSSIN",Trig) == 0 ) {
      trigV = 5;
   } else if ( strcmp("COS3",Trig) == 0 ) {
      trigV = 6;
   } else if ( strcmp("SIN3",Trig) == 0 ) {
      trigV = 7;
   } else if ( strcmp("SIN2COS",Trig) == 0 ) {
      trigV = 8;
   } else if ( strcmp("COSSIN2",Trig) == 0 ) {
      trigV = 8;
   } else if ( strcmp("SINCOS2",Trig) == 0 ) {
      trigV = 9;
   } else if ( strcmp("COS2SIN",Trig) == 0 ) {
      trigV = 9;
   }

/* GET the global information we'll need                                 */

   Tcl_UpVar(tI, "#0", "mANS", "mAnS", 0);
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "0,NSEN", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nT);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "nE", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nE);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "Sector", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nS);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "SpiN", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &sP);
   }

   ToT = nE * nS;
   SgN = (sP > 0) ? 1.0 : -1.0;

/* GET the work array memory and put the array data into it              */

   Bytes = sizeof(ReaL_8) * nT * nE * 2;
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }
   dA = (ReaL_8 *)memPtr;
   dB = (ReaL_8 *)memPtr + nT * nE;

/* GET the input array names                                             */

   pName = Tcl_GetStringFromObj(objv[1], (int *)0);
   aName = Tcl_GetStringFromObj(objv[2], (int *)0);
   bName = Tcl_GetStringFromObj(objv[3], (int *)0);
   rName = Tcl_GetStringFromObj(objv[4], (int *)0);
   rV1 = Tcl_NewObj();

   N = 0;
   switch (trigV) {
      case 0:
         pB = 0;
	 for (K = 0; K < nS; ++K, pB += nE) {
            J = pB;
	    L = (pB + nE) % ToT;
            dP1 = dA;
            dP2 = dB;
	    for (I = 0; I < nE; ++I, ++J, ++L) {
               sprintf(Index, "%d", J);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &lP);
               sprintf(Index, "%d", L);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &cP);

	       ConD = SgN * (cP - lP);
               hP = (ConD < 0) ? (cP + TwoPI) : cP;
	       *dP2++ = SgN * (hP - lP);
	       *dP1++ = SgN * (hP * hP - lP * lP) / 2.0;
            }
	    for (J = 0; J < nT; ++J) {
               dP1 = dA;
               dP2 = dB;
	       for (I = 0; I < nE; ++I, ++N) {
                  sprintf(Index, "%d", N);
                  rVO = Tcl_GetVar2Ex(tI, aName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &A);
                  rVO = Tcl_GetVar2Ex(tI, bName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &B);

		  V = A * *dP1++ + B * *dP2++;

                  rV1 = Tcl_DuplicateObj(rV1);
                  Tcl_SetDoubleObj (rV1, V);
		  Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
               }
            }
         }
      break;
      case 1:
         pB = 0;
	 for (K = 0; K < nS; ++K, pB += nE) {
            J = pB;
	    L = (pB + nE) % ToT;
            dP1 = dA;
            dP2 = dB;
	    for (I = 0; I < nE; ++I, ++J, ++L) {
               sprintf(Index, "%d", J);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &lP);
               sprintf(Index, "%d", L);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &cP);

	       ConD = SgN * (cP - lP);
               hP = (ConD < 0) ? (cP + TwoPI) : cP;
	       cH = cos(hP);
	       cL = cos(lP);
	       sH = sin(hP);
	       sL = sin(lP);
	       *dP1++ = sH - hP * cH - (sL - lP * cL);
	       *dP2++ = -cH + cL;
            }
	    for (J = 0; J < nT; ++J) {
               dP1 = dA;
               dP2 = dB;
	       for (I = 0; I < nE; ++I, ++N) {
                  sprintf(Index, "%d", N);
                  rVO = Tcl_GetVar2Ex(tI, aName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &A);
                  rVO = Tcl_GetVar2Ex(tI, bName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &B);

		  V = A * *dP1++ + B * *dP2++;

                  rV1 = Tcl_DuplicateObj(rV1);
                  Tcl_SetDoubleObj (rV1, V);
		  Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
               }
            }
         }
      break;
      case 2:
         pB = 0;
	 for (K = 0; K < nS; ++K, pB += nE) {
            J = pB;
	    L = (pB + nE) % ToT;
            dP1 = dA;
            dP2 = dB;
	    for (I = 0; I < nE; ++I, ++J, ++L) {
               sprintf(Index, "%d", J);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &lP);
               sprintf(Index, "%d", L);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &cP);

	       ConD = SgN * (cP - lP);
               hP = (ConD < 0) ? (cP + TwoPI) : cP;
	       cH = cos(hP);
	       cL = cos(lP);
	       sH = sin(hP);
	       sL = sin(lP);
	       dA[I] = cH + hP * sH - (cL + lP * sL);
	       dB[I] = sH - sL;
            }
	    for (J = 0; J < nT; ++J) {
               dP1 = dA;
               dP2 = dB;
	       for (I = 0; I < nE; ++I, ++N) {
                  sprintf(Index, "%d", N);
                  rVO = Tcl_GetVar2Ex(tI, aName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &A);
                  rVO = Tcl_GetVar2Ex(tI, bName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &B);

		  V = A * *dP1++ + B * *dP2++;

                  rV1 = Tcl_DuplicateObj(rV1);
                  Tcl_SetDoubleObj (rV1, V);
		  Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
               }
            }
         }
      break;
      case 3:
         pB = 0;
	 for (K = 0; K < nS; ++K, pB += nE) {
            J = pB;
	    L = (pB + nE) % ToT;
            dP1 = dA;
            dP2 = dB;
	    for (I = 0; I < nE; ++I, ++J, ++L) {
               sprintf(Index, "%d", J);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &lP);
               sprintf(Index, "%d", L);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &cP);

	       ConD = SgN * (cP - lP);
	       lP *= 2;
               hP = (ConD < 0) ? (2.0 * (cP + TwoPI)) : 2.0 * cP;
	       cH = cos(hP);
	       cL = cos(lP);
	       sH = sin(hP);
	       sL = sin(lP);
	       dA[I] = ((hP * hP - lP * lP) / 2.0
			       + hP * sH - lP * sL + cH - cL) / 8.0;
	       dB[I] = (hP + sH - lP - sL) / 4.;
            }
	    for (J = 0; J < nT; ++J) {
               dP1 = dA;
               dP2 = dB;
	       for (I = 0; I < nE; ++I, ++N) {
                  sprintf(Index, "%d", N);
                  rVO = Tcl_GetVar2Ex(tI, aName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &A);
                  rVO = Tcl_GetVar2Ex(tI, bName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &B);

		  V = A * *dP1++ + B * *dP2++;

                  rV1 = Tcl_DuplicateObj(rV1);
                  Tcl_SetDoubleObj (rV1, V);
		  Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
               }
            }
         }
      break;
      case 4:
         pB = 0;
	 for (K = 0; K < nS; ++K, pB += nE) {
            J = pB;
	    L = (pB + nE) % ToT;
            dP1 = dA;
            dP2 = dB;
	    for (I = 0; I < nE; ++I, ++J, ++L) {
               sprintf(Index, "%d", J);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &lP);
               sprintf(Index, "%d", L);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &cP);

	       ConD = SgN * (cP - lP);
	       lP *= 2;
               hP = (ConD < 0) ? (2.0 * (cP + TwoPI)) : 2.0 * cP;
	       cH = cos(hP);
	       cL = cos(lP);
	       sH = sin(hP);
	       sL = sin(lP);
	       dA[I] = ((hP * hP - lP * lP) / 2.0
			       - hP * sH + lP * sL - cH + cL) / 8.0;
	       dB[I] = (hP - sH - lP + sL) / 4.;
            }
	    for (J = 0; J < nT; ++J) {
               dP1 = dA;
               dP2 = dB;
	       for (I = 0; I < nE; ++I, ++N) {
                  sprintf(Index, "%d", N);
                  rVO = Tcl_GetVar2Ex(tI, aName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &A);
                  rVO = Tcl_GetVar2Ex(tI, bName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &B);

		  V = A * *dP1++ + B * *dP2++;

                  rV1 = Tcl_DuplicateObj(rV1);
                  Tcl_SetDoubleObj (rV1, V);
		  Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
               }
            }
         }
      break;
      case 5:
         pB = 0;
	 for (K = 0; K < nS; ++K, pB += nE) {
            J = pB;
	    L = (pB + nE) % ToT;
            dP1 = dA;
            dP2 = dB;
	    for (I = 0; I < nE; ++I, ++J, ++L) {
               sprintf(Index, "%d", J);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &lP);
	       l2P = 2.0 * lP;
               sprintf(Index, "%d", L);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &cP);

	       ConD = SgN * (cP - lP);
               if (ConD < 0) {
		  hP = (cP + TwoPI);
                  h2P = 2.0 * hP;
               } else {
                  hP = cP;
                  h2P = 2.0 * cP;
               }
	       sH = sin(hP);
	       sL = sin(lP);
	       s2H = sin(h2P);
	       s2L = sin(l2P);
	       sH2 = sH *sH;
	       sL2 = sL *sL;
	       dA[I] = (hP * sH2 - lP * sL2)/2.0 - (h2P - s2H - l2P + s2L)/8.0;
	       dB[I] = (sH2 - sL2) / 2.0;
            }
	    for (J = 0; J < nT; ++J) {
               dP1 = dA;
               dP2 = dB;
	       for (I = 0; I < nE; ++I, ++N) {
                  sprintf(Index, "%d", N);
                  rVO = Tcl_GetVar2Ex(tI, aName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &A);
                  rVO = Tcl_GetVar2Ex(tI, bName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &B);

		  V = A * *dP1++ + B * *dP2++;

                  rV1 = Tcl_DuplicateObj(rV1);
                  Tcl_SetDoubleObj (rV1, V);
		  Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
               }
            }
         }
      break;
      case 6:
         pB = 0;
	 for (K = 0; K < nS; ++K, pB += nE) {
            J = pB;
	    L = (pB + nE) % ToT;
            dP1 = dA;
            dP2 = dB;
	    for (I = 0; I < nE; ++I, ++J, ++L) {
               sprintf(Index, "%d", J);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &lP);
	       l3P = 3.0 * lP;
               sprintf(Index, "%d", L);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &cP);

	       ConD = SgN * (cP - lP);
               if (ConD < 0) {
		  hP = (cP + TwoPI);
                  h3P = 3.0 * hP;
               } else {
                  hP = cP;
                  h3P = 3.0 * cP;
               }
	       sH = sin(hP);
	       sL = sin(lP);
	       cH = cos(hP);
	       cL = cos(lP);
	       s3H = sin(h3P);
	       s3L = sin(l3P);
	       c3H = cos(h3P);
	       c3L = cos(l3P);
	       dA[I] = (h3P * s3H + c3H - l3P * s3L - c3L) / 36.0 
		           + 3.0 * (hP * sH + cH - lP * sL - cL) / 4.0;
	       dB[I] = sH - sH * sH * sH / 3.0 - sL + sL * sL * sL / 3.0; 
            }
	    for (J = 0; J < nT; ++J) {
               dP1 = dA;
               dP2 = dB;
	       for (I = 0; I < nE; ++I, ++N) {
                  sprintf(Index, "%d", N);
                  rVO = Tcl_GetVar2Ex(tI, aName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &A);
                  rVO = Tcl_GetVar2Ex(tI, bName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &B);

		  V = A * *dP1++ + B * *dP2++;

                  rV1 = Tcl_DuplicateObj(rV1);
                  Tcl_SetDoubleObj (rV1, V);
		  Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
               }
            }
         }
      break;
      case 7:
         pB = 0;
	 for (K = 0; K < nS; ++K, pB += nE) {
            J = pB;
	    L = (pB + nE) % ToT;
            dP1 = dA;
            dP2 = dB;
	    for (I = 0; I < nE; ++I, ++J, ++L) {
               sprintf(Index, "%d", J);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &lP);
	       l3P = 3.0 * lP;
               sprintf(Index, "%d", L);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &cP);

	       ConD = SgN * (cP - lP);
               if (ConD < 0) {
		  hP = (cP + TwoPI);
                  h3P = 3.0 * hP;
               } else {
                  hP = cP;
                  h3P = 3.0 * cP;
               }
	       sH = sin(hP);
	       sL = sin(lP);
	       cH = cos(hP);
	       cL = cos(lP);
	       s3H = sin(h3P);
	       s3L = sin(l3P);
	       c3H = cos(h3P);
	       c3L = cos(l3P);
	       dA[I] = (h3P * c3H - s3H - l3P * c3L + s3L) / 36.0 
		           + 3.0 * (sH - hP * cH - sL + lP * cL) / 4.0;
	       dB[I] = cH * cH * cH / 3.0 - cH - cL * cL * cL / 3.0 + cL; 
            }
	    for (J = 0; J < nT; ++J) {
               dP1 = dA;
               dP2 = dB;
	       for (I = 0; I < nE; ++I, ++N) {
                  sprintf(Index, "%d", N);
                  rVO = Tcl_GetVar2Ex(tI, aName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &A);
                  rVO = Tcl_GetVar2Ex(tI, bName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &B);

		  V = A * *dP1++ + B * *dP2++;

                  rV1 = Tcl_DuplicateObj(rV1);
                  Tcl_SetDoubleObj (rV1, V);
		  Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
               }
            }
         }
      break;
      case 8:
         pB = 0;
	 for (K = 0; K < nS; ++K, pB += nE) {
            J = pB;
	    L = (pB + nE) % ToT;
            dP1 = dA;
            dP2 = dB;
	    for (I = 0; I < nE; ++I, ++J, ++L) {
               sprintf(Index, "%d", J);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &lP);
               sprintf(Index, "%d", L);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &cP);

	       ConD = SgN * (cP - lP);
               hP = (ConD < 0) ? cP + TwoPI : cP;
	       sH = sin(hP);
	       sL = sin(lP);
	       cH = cos(hP);
	       cL = cos(lP);
	       sH3 = sH * sH * sH;
	       sL3 = sL * sL * sL;
	       cH3 = cH * cH * cH;
	       cL3 = cL * cL * cL;
	       dA[I] = (hP * sH3 - cH3 / 3.0 + cH
		           - lP * sL3 + cL3 / 3.0 - cL) / 3.0;
	       dB[I] = (sH3 - sL3) / 3.0;
            }
	    for (J = 0; J < nT; ++J) {
               dP1 = dA;
               dP2 = dB;
	       for (I = 0; I < nE; ++I, ++N) {
                  sprintf(Index, "%d", N);
                  rVO = Tcl_GetVar2Ex(tI, aName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &A);
                  rVO = Tcl_GetVar2Ex(tI, bName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &B);

		  V = A * *dP1++ + B * *dP2++;

                  rV1 = Tcl_DuplicateObj(rV1);
                  Tcl_SetDoubleObj (rV1, V);
		  Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
               }
            }
         }
      break;
      case 9:
         pB = 0;
	 for (K = 0; K < nS; ++K, pB += nE) {
            J = pB;
	    L = (pB + nE) % ToT;
            dP1 = dA;
            dP2 = dB;
	    for (I = 0; I < nE; ++I, ++J, ++L) {
               sprintf(Index, "%d", J);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &lP);
               sprintf(Index, "%d", L);
               rVO = Tcl_GetVar2Ex(tI, pName, Index, Flg);
               Tcl_GetDoubleFromObj (tI, rVO, &cP);

	       ConD = SgN * (cP - lP);
               hP = (ConD < 0) ? cP + TwoPI : cP;
	       sH = sin(hP);
	       sL = sin(lP);
	       cH = cos(hP);
	       cL = cos(lP);
	       sH3 = (sH * sH * sH / 3.0);
	       sL3 = (sL * sL * sL / 3.0);
	       cH3 = cH * cH * cH;
	       cL3 = cL * cL * cL;
	       dA[I] = (-hP * cH3 + sH - sH3 + lP * cL3 - sL + sL3) / 3.0;
	       dB[I] = -(cH3 - cL3) / 3.0;
            }
	    for (J = 0; J < nT; ++J) {
               dP1 = dA;
               dP2 = dB;
	       for (I = 0; I < nE; ++I, ++N) {
                  sprintf(Index, "%d", N);
                  rVO = Tcl_GetVar2Ex(tI, aName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &A);
                  rVO = Tcl_GetVar2Ex(tI, bName, Index, Flg);
                  Tcl_GetDoubleFromObj (tI, rVO, &B);

		  V = A * *dP1++ + B * *dP2++;

                  rV1 = Tcl_DuplicateObj(rV1);
                  Tcl_SetDoubleObj (rV1, V);
		  Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
               }
            }
         }
      break;
   }

   free (memPtr);
   return TCL_OK;
}
