# THIS procedure produces the start and stop velocity for each energy bin
#    At the same time determine start and stop indices to be used in the
#    integration in the case we are computing moments over a limited
#    energy range.

package provide MOments 1.0

proc MOvelComps { sN { Read 1 } } {
   global mANS vBImG vEImG eBImG eEImG

   if $Read {
      switch -exact -- $mANS(aData) {
         LU -
         LC -
         CU {
	    set uA [lindex $mANS($sN,aUnit) 0]
            ConvertToUnits $mANS($sN,KeY) 0 0 $uA eBImG
	    set uB [lindex $mANS($sN,aUnit2) 0]
	    ConvertToUnits $mANS($sN,KeY) 0 0 $uB eEImG
	    MOhiloEv $sN
	 }
         C {
	    set uA [lindex $mANS($sN,aUnit) 0]
            ConvertToUnits $mANS($sN,KeY) 0 0 $uA eBImG
	    MOhiloEv $sN
	 }
      }
   } else {

      MOspCut

# DETERMINE the start and ending integration point in the energy or velocity
#   array.  This is done either pre or post application of the spacecraft
#   potential

      if { $eBImG(0) < $eBImG(1) } {
          set mANS(bEP) 0
          set mANS(eEP) [expr $mANS(nE) - 1] 
      } else {
          set mANS(eEP) 0
          set mANS(bEP) [expr $mANS(nE) - 1] 
      }

      if !$mANS(appE) { 
          set PV 0.0 
      } else { set PV [expr $mANS(pVSgn)abs($mANS(PV0)) + $mANS(pVOff)] } 

      for { set I 0 } { $I < $mANS(nE) } { incr I } {
         set E1 [expr $eBImG($I) + $PV]
         set E2 [expr $eEImG($I) + $PV]
         if { $E1 > $E2 } {
            set TmP $E1
            set E1 $E2
            set E2 $TmP
         }

         if $mANS(pVExt) {
            if { ($E1 < 0.0) && ($E2 > 0.0) } { set E1 0.0 }
            if { ($E1 < 0.0) && ($E2 < 0.0) } { set E1 0.0 ; set E2 0.0 }
         } else {
            if { ($E1 < 0.0) || ($E2 < 0.0) } { set E1 0.0 ; set E2 0.0 }
         }

         if {($mANS(bEv) >= $E1) && ($mANS(bEv) < $E2)} {set mANS(bEP) $I}
         if {($mANS(eEv) >= $E1) && ($mANS(eEv) < $E2)} {set mANS(eEP) $I}
      }

      if { $mANS(eEP) < $mANS(bEP) } {
         set TmP $mANS(bEP) 
         set mANS(bEP) $mANS(eEP)
         set mANS(eEP) $TmP
      }
   }
}
