#  THIS procedure checks to make sure that the center time of the flag falls
#     within the time of moment

package provide MOments 1.0

proc MOtimeCheck { S Frac } {
   global mANS

   upvar $Frac F

   set FmT "%4d%03d%08d"

   set tA [format $FmT $mANS(bY) $mANS(bD) $mANS(bM)]
   set tB [format $FmT $mANS(eY) $mANS(eD) $mANS(eM)]
   set mA [format $FmT $mANS($S,bfYr) $mANS($S,bfDy) $mANS($S,bfMs)]
   set mB [format $FmT $mANS($S,efYr) $mANS($S,efDy) $mANS($S,efMs)]

   set rmA [string match $tA $mA] 
   set rmB [string match $tB $mB]
   set rma [string match $tA $mB] 
   set rmb [string match $tB $mA]
   set tList [lsort -ascii -increasing [list $tA $mA $tB]]
   set rA [lsearch $tList $mA]
   set tList [lsort -ascii -increasing [list $tA $mB $tB]]
   set rB [lsearch $tList $mB]

   if $rmA { set rA 1 } elseif $rmb { set rA 2 }
   if $rmB { set rB 1 } elseif $rma { set rB 0 }

   set rV $rA$rB$rmA$rmB$rma$rmb

   switch -exact -- $rV {
      000000 - 
      000010 {
         set rV 0
         set F  0.0
      }
      220000 -
      220001 { 
         set rV 2
 	 set F  0.0
      }
      110000 - 
      111100 -
      010100 {
         set rV 1
	 set F  1.0
      }
      020000 -
      121000 {
         set rV 3
 	 set F  1.0
      }
      010000 {
         set rV 1
	 set dTm [expr $mANS(eM) - $mANS(bM)]
	 if { $dTm < 0 } { set dTm [expr $dTm + 86400000] } 
	 set dT  [expr $mANS($S,efMs) - $mANS(bM)]
	 if { $dT < 0 } { set dT [expr $dT + 86400000] } 
	 set F [expr double($dT)/$dTm]
      }
      120000 {
         set rV 2
	 set dTm [expr $mANS(eM) - $mANS(bM)]
	 if { $dTm < 0 } { set dTm [expr $dTm + 86400000] } 
	 set dT  [expr $mANS(eM) - $mANS($S,bfMs)]
	 if { $dT < 0 } { set dT [expr $dT + 86400000] } 
	 set F [expr double($dT)/$dTm]
      }
   }

   return $rV
}
