# THIS procedure removes energy steps which are below or include the 
#   spacecraft potential by setting their upper and lower edges to 0.0.
#   There is an option to allow energy steps which include the potential
#   by setting their lower edge to 0.0 and their DF value to that of the
#   first energy band above the potential.  

package provide MOments 1.0

proc MOspCut { } {
   global mANS vBImG vEImG eBImG eEImG dfImG

# THIS is the potential for this spin

   set PV [expr $mANS(pVSgn)abs($mANS(PV0)) + $mANS(pVOff)]

# SET the potential corrected velocities used in the integration.

   for { set I 0 } { $I < $mANS(nE) } { incr I } {
      set E1 [expr $eBImG($I) + $PV]
      set E2 [expr $eEImG($I) + $PV]
      if { $E1 > $E2 } {
         set TmP $E1
         set E1 $E2
         set E2 $TmP
      }

      if $mANS(pVExt) {
         if { ($E1 < 0.0) && ($E2 >= 0.0) } { set E1 0.0 }
         if { ($E1 < 0.0) && ($E2 < 0.0) } { set E1 0.0 ; set E2 0.0 }
      } else {
         if { ($E1 < 0.0) || ($E2 < 0.0) } { set E1 0.0 ; set E2 0.0 }
      }

      set vBImG($I) [expr sqrt($E1 * $mANS(toV))]
      set vEImG($I) [expr sqrt($E2 * $mANS(toV))]
   }    

# IF we are including the energy bin which contains the potential then
#   figure out which energy step the potential is in.  Flag it and the
#   last energy step which was totally above the potential

   if $mANS(pVExt) {
      set PV [expr -$PV]
      if { $eBImG(0) > $eEImG(0) } {
         upvar 0 eBImG eH  
         upvar 0 eEImG eL  
      } else {
         upvar 0 eEImG eH  
         upvar 0 eBImG eL  
      }

      set aS -1
      set gS -1

      set I 0
      while { ($aS < 0) && ($I < $mANS(nE)) } { 
         if { $eL($I) >= $PV } {
            set gS $I
         } elseif { ($eL($I) < $PV) && ($eH($I) > $PV) } {
            set aS $I
 	   if { $gS < 0 } { set gS [expr $I + 1] }
         }
         incr I
      }

# COPY the DF function from the first full energy band to the added energy
#   band.  Do this only if we are modifying one of the energy bands!

      if { $aS >= 0 } {
         set TotV [expr $mANS(Sector) * $mANS(0,NSEN) * $mANS(nE)]
         while { $aS < $TotV } {
            set dfImG($aS) $dfImG($gS)
            incr aS $mANS(nE)
            incr gS $mANS(nE)
         }
      }
   }
}
