#  THIS procedure opens the UDF files

package provide MOments 1.0

proc MOopenUDF { sN bY bD bH bM bS eY eD eH eM eS } {
   global SInfo mANS Pidf0 ExDa MFrotM

# THIS is the UDF id flag

   set iD UD$sN

# OPEN the main UDF data file from which the moments will be computed

   set Key [GetDataKey $mANS($iD,P) $mANS($iD,M) $mANS($iD,E) \
                       $mANS($iD,I) $mANS($iD,V)]

   FileOpen $Key 0 $bY $bD $bH $bM $bS $eY $eD $eH $eM $eS

   if { [string match MOMENTS $mANS($sN,sType)] && \
             [string match "Closest Spin" $mANS(BegFlg)] } {
      set fPFlg COARSE 
   } else { set fPFlg FINE }

   FilePos  $Key 0 $bY $bD $bH $bM $bS $fPFlg

# SAVE the Key

   set mANS($sN,KeY)   $Key

# FIND out how many sensor definitions are being returned. Each definition
#   can contain multiple measurements but these all use the same algorithm
#   to convert to units.

   set nsD [llength $mANS($iD,SenL)]

# SET up information variables for each sensor

   set mANS($sN,sNum) ""
   set mANS($sN,sUnit) ""
   set mANS($sN,aUnit) ""
   set mANS($sN,aUnit2) ""
   set mANS($sN,uName) ""
   set mANS($sN,sName) ""

   set uD $sN.s0

# Define all of the sensors for this UDF definition

   for { set I 0 } { $I < $nsD } { incr I } {
      if ![lindex $mANS($iD,SenL) $I] { continue }
      set nD $iD.s$I

# GET all the vidf numbers for all the sensors which need to be retrieved

      set sI [UUgetSensors $Key $mANS($nD,scr) $mANS($nD,srcA) \
                             $mANS($nD,meaA) $mANS($nD,munA) ] 

# GET the sensor name and unit descriptions

      set vsI [lindex $sI 0]
      set sL [UUgetSNames $Key [lindex $sI 1] FULL]
      set uN [UUgetUNames $Key  $mANS($nD,munA) LONG]

# GET the sensor unit conversion algorithm

      set suN [lindex $uN 1]
      set uS [UUunitAlg $Key,0 $mANS($nD,munA) $mANS($nD,meaA)]
      set uA "" ; set uA2 ""
      if [string match MOMENTS $mANS($sN,sType)] {
         set uA [UUunitAlg $Key,0 $mANS($nD,iunA) $mANS($nD,meaA)]
         set mANS(0,NSEN) [llength [lindex $sI 0]]
      } 
      if ![string match C $mANS(aData)] {
         if [string match MOMENTS $mANS($sN,sType)] {
            set uA2 [UUunitAlg $Key,0 $mANS($nD,iun2A) $mANS($nD,meaA)]
         } 
      } 

# LOAD them up into the definitions

      set nSen [llength $vsI]
      for { set J 0 } { $J < $nSen } { incr J } {
         lappend mANS($sN,sNum) [lindex $vsI $J]
         lappend mANS($sN,sUnit)  $uS
         lappend mANS($sN,aUnit)  $uA
         lappend mANS($sN,aUnit2) $uA2
         lappend mANS($sN,uName) $suN
         lappend mANS($sN,sName) [lindex $sL $J]
      }

# IF there are any measurements which are to be included in the moments
#   file, flag them and get their offsets.

      set InFo [string match INFO $mANS($sN,sType)]
      if { $InFo || (!$InFo && [string match YES $mANS($sN,AddInfo)]) } {
         set Pos $mANS(iOff)
         set mANS(iOff) [expr $Pos + [llength $mANS($sN,sNum)] ]
      } else { set Pos -1 }

      lappend mANS(iOffsets) $Pos
   }

   set mANS($sN,tChk) 0
   set mANS($sN,EOF) 0

# IN case we need it form the rotation matrix which will take MF data to
#    PEACE coordinates.  Only work for moments derived from PEACE data 

   set mU UD[lindex $mANS(MOMENTS) 0]
   if [string match PEACE $mANS($mU,E)] {
      set bT [list $bY $bD $bH $bM $bS]
      set eT [list $eY $eD $eH $eM $eS]
      MOtoScSys MFrotM PEACE_FGM [list $mANS($mU,P) $mANS($mU,M)] $bT $eT
   }
}
