#  THIS procedure opens the CAA files

package provide MOments 1.0

proc MOopenCAA { sN sY sD sH sM sS fY fD fH fM fS } {
   global mANS GSEtoSC

# FIND out what data set this open is for

   if { $mANS(MAGFIELD) == $sN } {
      set FmT "%d-%d-%dT%d:%d:%fZ,%f,%f,%f,%f,"
      set rCmD {scan $LiNe $FmT bY bMo bD bH bM bS _T1 S(0) S(1) S(2)}
      set nS 3
   } elseif { $mANS(POTENTIAL) == $sN } {
      set FmT "%d-%d-%dT%d:%d:%fZ,%f,"
      set rCmD {scan $LiNe $FmT bY bMo bD bH bM bS S(0)}
      set nS 1
   } else {
      puts stderr "SOURCE $sN is not a CAA source"
      exit -1
   }

# IF there are any measurements which are to be included in the moments
#   file, flag them and get their offsets.

   if [string match YES $mANS($sN,AddInfo)] {
     set Pos $mANS(iOff)
     set mANS(iOff) [expr $Pos + $nS]
   } else { set Pos -1 }
   lappend mANS(iOffsets) $Pos

# GET start MS

   set sMs [expr int(($sH * 3600 + $sM * 60 + $sS) * 1000)]
   set tBase 1

# SINCE the file is not random access we will need to open it twice.
#   In the first open we get the measurement dT.  In the second we do
#   the equivalent of Filepos on a UDF file.

# OPEN the file first time

   if [catch {open $mANS($sN,caaFn) r} fd ] {
      puts stderr "CAN'T OPEN FILE $mANS($sN,caaFn) "
      exit -1
   }

# SKIP over the header info

   set StoP 0
   while { !$StoP } {
      gets $fd LiNe
      set LiNe [string trim $LiNe]
      set fS [expr [string first " " $LiNe] - 1]
      if { $fS >= 0 } { set LiNe [string range $LiNe 0 $fS] }
      set StoP [string match DATA_UNTIL $LiNe]
   }

# GET the first time in the file

   set EOF [gets $fd LiNe] 
   eval $rCmD

   set YD [TUtimeFmt 5 $bY $bMo $bD]
   scan $YD "%4d%3d" bY bD
   set bMs [expr int(($bH * 3600 + $bM * 60 + $bS) * 1000)]
   set bT [list $bY $bD $bMs 0]

# INITIALIZE variables used to compute dT

   set mANS($sN,dT) 0
   set dTa $bMs
   set dTb -1
   set dTc -1
   set ToK 0

# COMPUTE the dT for the measurement

   while { ($EOF >= 0) && !$ToK } {
      set EOF [gets $fd LiNe]
      if { $EOF > 0 } {
         eval $rCmD
         set YD [TUtimeFmt 5 $bY $bMo $bD]
         scan $YD "%4d%3d" bY bD
         set bMs [expr int(($bH * 3600 + $bM * 60 + $bS) * 1000)]
         set bT [list $bY $bD $bMs 0]

	 if { $dTb >= 0 } { 
	    if { $dTc <= 0 } { 
	       set dTc $bMs
	       set R [expr double ($dTb - $dTa) / double ($dTc - $dTb)]
	       if { (($R < 1.1) && ($R > 0.9)) } { 
	          set ToK 1 
                  set mANS($sN,dT) [expr $dTb - $dTa]
               } else {
	          set dTa $dTb
	          set dTb $dTc
	          set dTa -1
	        }
	    } 
	 } else { set dTb $bMs }
      }
   }

   close $fd

   if !$ToK { puts stderr "ERROR - measurement has no width!" ; exit -1 }


# OPEN the file for second time

   if [catch {open $mANS($sN,caaFn) r} fd ] {
      puts stderr "CAN'T OPEN FILE $mANS($sN,caaFn) "
      exit -1
   }

# SKIP over the header info ... again

   set StoP 0
   while { !$StoP } {
      gets $fd LiNe
      set LiNe [string trim $LiNe]
      set fS [expr [string first " " $LiNe] - 1]
      if { $fS >= 0 } { set LiNe [string range $LiNe 0 $fS] }
      set StoP [string match DATA_UNTIL $LiNe]
   }

# GET the first time in the file

   set EOF [gets $fd LiNe] 
   eval $rCmD

   set YD [TUtimeFmt 5 $bY $bMo $bD]
   scan $YD "%4d%3d" bY bD
   set bMs [expr int(($bH * 3600 + $bM * 60 + $bS) * 1000)]
   set bT [list $bY $bD $bMs 0]

# GET the difference in seconds from beginning to the requested start time
   
   set ubT [list $sY $sD $sMs 0]
   set tBeg [TUtimeConv $ubT $bT 0 tBase]
   if  { $tBeg >= 0 } { set DonE 1 } else { set DonE 0 }

# POSITION into file as close to the start time as possible

   while { ( $EOF >= 0 ) && !$DonE } {
      set EOF [gets $fd LiNe]
      if { $EOF > 0 } {
         eval $rCmD
         set YD [TUtimeFmt 5 $bY $bMo $bD]
         scan $YD "%4d%3d" bY bD
         set bMs [expr int(($bH * 3600 + $bM * 60 + $bS) * 1000)]
         set bT [list $bY $bD $bMs 0]

         set curT [TUtimeConv $ubT $bT 0 tBase]
	 if { $curT >= 0 } { set DonE 1 }
      }
   }

# GET the start and ending time of this measurement

   set mANS($sN,bfYr) $bY
   set mANS($sN,efYr) $bY
   set mANS($sN,bfDy) $bD
   set mANS($sN,efDy) $bD
   set mANS($sN,bfMs) $bMs
   set mANS($sN,efMs) [expr $bMs + $mANS($sN,dT)]
   if { $mANS($sN,efMs) > 86400000 } {
      set mANS($sN,efMs) [ expr $mANS($sN,efMs) - 86400000]
      incr mANS($sN,efDy) 
      if { $$mANS($sN,efDy) > [TUyearLeap $mANS($sN,efYr)] } {
         set mANS($sN,efDy) 1 
         incr mANS($sN,efYr) 
      }
   }

   if { $EOF > 0 } { set mANS($sN,EOF) 0 } else { set mANS($sN,EOF) 1 }
   set mANS($sN,fd) $fd
   set mANS($sN,tChk) -100
   for { set I 0 } { $I < $nS } { incr I } {
      set mANS($sN,cV$I) $S($I)
   }
}
