# This procedure saves the Moments menu entries

package provide MOments 1.0
                                                                                
proc MOmenuSave { } {
   global env mANS

   if [catch {open $mANS(MenuSave) w} fd] {
      puts stderr "UNABLE TO OPEN SAVEFILE: $mANS(MenuSave)"
      return
   }

# SAVE the time menu

   MOallInits TIME

   puts $fd "BEGIN TIME"
   set nV [MOvarList TIME vL]
   for { set I 0 } { $I < $nV } { incr I } {
      set vN [lindex [lindex $vL $I] 0]
      puts $fd "$vN|$mANS($vN)"
   }
   puts $fd "END TIME"

# SAVE the variable definitions if there are any

   if ![winfo exists .moVAR] { MOguiVar 1 }
   set W .moVAR.body.list
   MOsetSBase

# THIS is the number of variable definitions

   set nS [$W index end]

   if { $nS > 0 } { 
      puts $fd "BEGIN VARIABLE"

      for { set I 0 } { $I < $nS } { incr I } {
         set vDef [$W get $I]
         scan $vDef "%d" sN
      
         puts $fd "BEGIN VSLOT $I"

         MOallInits VARIABLE $sN
         set nV [MOvarList VARIABLE vL]
         for { set J 0 } { $J < $nV } { incr J } {
            set vI [lindex $vL $J]
            set vN [lindex $vI 0]
            puts $fd "$I,$vN|$mANS($sN,[lindex [lindex $vL $J] 0])"
         }

         if [string match UDF $mANS($sN,sBase)] {
            puts $fd "BEGIN UDFSRC $I"
            set mANS(UD$I,Title) "UDF DEFINITION $I"
	    GUsaveUDF $fd UD$sN mANS UD$I
            puts $fd "END UDFSRC"
         }
         puts $fd "END VSLOT"
      }
      puts $fd "END VARIABLE"
   } 

# SAVE the limits and offsets menu

   MOallInits LIMITS

   puts $fd "BEGIN LIMITS"
   set nV [MOvarList LIMITS vL]
   for { set I 0 } { $I < $nV } { incr I } {
      set vN [lindex [lindex $vL $I] 0]
      puts $fd "$vN|$mANS($vN)"
   }
   puts $fd "END LIMITS"

# SAVE the masks menu

# SAVE the variable definitions if there are any

   if ![winfo exists .moMask] { MOguiMasks 1 }
   set W .moMask.body.list

# THIS is the number of mask definitions

   set nS [$W index end]

   if { $nS > 0 } { 
      puts $fd "BEGIN MASKS"

      set nV [MOvarList MASKS vL]
      set FmT "%s"
      set VaR "A(0)"
      for { set I 1 } { $I < $nV } { incr I } {
          append FmT " %s"
          append VaR " A($I)"
      }
      for { set I 0 } { $I < $nV } { incr I } { set B($I) "" }

      for { set I 0 } { $I < $nS } { incr I } {
         set LiNe [$W get $I]
	 set LiNe [string trim $LiNe]
	 set rCmd { scan "$LiNe" "$FmT" }
	 append rCmd $VaR
	 eval $rCmd
         for { set J 0 } { $J < $nV } { incr J } {
	    lappend B($J) $A($J)
         }
      }

      for { set I 0 } { $I < $nV } { incr I } {
	  puts $fd "[lindex [lindex $vL $I] 0]|$B($I)"
      }

      puts $fd "END MASKS"
   }

   close $fd
}
