# THIS procedure reads a menu file to get all of the user set options

package provide MOments 1.0

proc MOmenuRead { } {
   global mANS GUIoptPri GUIoptAlts

   if [catch {open $mANS(MenuRead) r} fd] {
      puts stderr "UNABLE TO OPEN MENUFILE: $mANS(MenuRead)"
      return
   }

#  READ in the saved values.  Blocks or saved replies in the menu are
#     separated by BEGIN and END.  These can be ignored.

   while { [gets $fd line] > 0 } {
      set nW [lindex $line 0] 
      if [string match END $nW]   { continue }
      if [string match BEGIN $nW] { 
         set fN [lindex $line 1]
	 if { [lsearch $mANS(fItems) $fN] >= 0 } {
             set pI ${fN},rd 
	     set mANS($pI) 1
         }
         continue 
      }

      set Fields [split $line '|']
      set I [lindex $Fields 0]

      set mANS($I) [lindex $Fields 1]

      if [string match $I mInv] {
         set nF [llength [lindex $Fields 1]]
	 set TmP ""
	 for { set J 0 } { $J < $nF } { incr J } {
	    set lF [lindex [lindex $Fields 1] $J]
	    if [string match "---" $lF ] {
	       lappend TmP NO 
            } else { lappend TmP $lF }
	 }

	 set mANS($I) $TmP
      }
   }

   close $fd
}
