# THIS procedure builds the integrate theta ImG
#
# INPUT:  Low  : array of the lower edges of the elevation bins
#         High : array of the upper edges of the elevation bins
#         Back : the returned integrated array
#         Trig : the trig functions being integrated
                                                                                
package provide MOments_C 1.0

proc MOmassintTh { Low High Back Trig } {
   global mANS

   upvar $Low   Lw
   upvar $High  Hi
   upvar $Back  rI
                                                                                
# SET up the sign to use when doing the integration.  This depends on
#   whether we are integrating low to hi or hi to low.

   if { $Lw(0) < $Hi(0) } { set SgN + } else { set SgN - }

   switch -exact -- $Trig {
      SIN {
         for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
            set L [expr -cos($Lw($I))]
            set H [expr -cos($Hi($I))]
	    set rI($I) [expr ${SgN}( $H - $L ) ]
         }
      }
      SIN2 {
         for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
            set P [expr 2.0 * $Lw($I)]
            set L [expr ($P - sin($P))/4.0]
            set P [expr 2.0 * $Hi($I)]
            set H [expr ($P - sin($P))/4.0]
	    set rI($I) [expr ${SgN}( $H - $L ) ]
         }
      }
      COSSIN -
      SINCOS {
         for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
            set sN [expr sin($Lw($I))]
            set L [expr $sN * $sN / 2.0]
            set sN [expr sin($Hi($I))]
            set H [expr $sN * $sN / 2.0]
	    set rI($I) [expr ${SgN}( $H - $L ) ]
         }
      }
      SIN3 {
         for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
            set cN [expr cos($Lw($I))]
            set L [expr ($cN * $cN * $cN) / 3.0 - $cN]
            set cN [expr cos($Hi($I))]
            set H [expr ($cN * $cN * $cN) / 3.0 - $cN]
	    set rI($I) [expr ${SgN}( $H - $L ) ]
         }
      }
      COSSIN2 -
      SIN2COS {
         for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
            set sN [expr sin($Lw($I))]
            set L [expr ($sN * $sN * $sN) / 3.0 ]
            set sN [expr sin($Hi($I))]
            set H [expr ($sN * $sN * $sN) / 3.0]
	    set rI($I) [expr ${SgN}( $H - $L ) ]
         }
      }
      COS2SIN -
      SINCOS2 {
         for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
            set cN [expr cos($Lw($I))]
            set L [expr -($cN * $cN * $cN) / 3.0 ]
            set cN [expr cos($Hi($I))]
            set H [expr -($cN * $cN * $cN) / 3.0]
	    set rI($I) [expr ${SgN}( $H - $L ) ]
         }
      }
      SIN4 {
         for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
            set P [expr 2.0 * $Lw($I)]
            set L [expr 3.0 * $P/16.0 - sin($P)/4.0 + sin(2.0 * $P)/32.0]
            set P [expr 2.0 * $Hi($I)]
            set H [expr 3.0 * $P/16.0 - sin($P)/4.0 + sin(2.0 * $P)/32.0]
	    set rI($I) [expr ${SgN}( $H - $L ) ]
         }
      }
      COS3SIN -
      SINCOS3 {
         for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
            set cN [expr cos($Lw($I))]
            set L [expr -($cN * $cN * $cN * $cN) / 4.0 ]
            set cN [expr cos($Hi($I))]
            set H [expr -($cN * $cN * $cN * $cN) / 4.0]
	    set rI($I) [expr ${SgN}( $H - $L ) ]
         }
      }
      COSSIN3 -
      SIN3COS {
         for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
            set sN [expr sin($Lw($I))]
            set L [expr ($sN * $sN * $sN * $sN) / 4.0 ]
            set sN [expr sin($Hi($I))]
            set H [expr ($sN * $sN * $sN * $sN) / 4.0]
	    set rI($I) [expr ${SgN}( $H - $L ) ]
         }
      }
      COS2SIN2 -
      SIN2COS2 {
         for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
            set P [expr 4.0 * $Lw($I)]
            set L [expr ($P - sin($P))/32.0]
            set P [expr 4.0 * $Hi($I)]
            set H [expr ($P - sin($P))/32.0]
	    set rI($I) [expr ${SgN}( $H - $L ) ]
         }
      }
   }
}
