# THIS procedure builds the integrate phi ImG 
#
# INPUT:  ImG  : the phase array ImG which is only the beginning angles
#         Back : the returned integrated array
#         Trig : the trig function being integrated

package provide MOments 1.0

proc MOmassintPh { ImG Back Trig } {
   global mANS TwoPI

   upvar $ImG   pI
   upvar $Back  rI

# The ImG array is set up to hold one sweeps worth of phase values per
#   sector.  All sensors from that sector use the same phase values.
#   tE is the number of phases per sector and ToT is the total length
#   of the ImG array

   set tE  $mANS(nE)
   set ToT [expr $tE * $mANS(Sector)]

# SET up the sign to use when doing the integration.  This depends on
#   whether we are integrating low to hi or hi to low.

   if { $mANS(SpiN) > 0 } { set SgN + } else { set SgN - }

   set N 0
   switch -exact -- $Trig {
      NONE {
         for { set I 0 } { $I < $ToT } { } {
            set EnD [expr $I + $tE]
            set J [expr $EnD % $ToT]
            for {  } { $I < $EnD } { incr I ; incr J } {
               set rI($N) [expr ${SgN}($pI($J) - $pI($I)) ]
               if { $rI($N) < 0.0 } { set rI($N) [expr $rI($N) + $TwoPI] }   
               incr N
            }
         }
      }
      SIN {
         for { set I 0 } { $I < $ToT } { } {
            set EnD [expr $I + $tE]
            set J [expr $EnD % $ToT]
            for {  } { $I < $EnD } { incr I ; incr J } {
               set L [expr -cos($pI($I))]
               set H [expr -cos($pI($J))]
               set rI($N) [expr ${SgN}( $H - $L )]
               incr N
            }
         }
      }
      COS {
         for { set I 0 } { $I < $ToT } { } {
            set EnD [expr $I + $tE]
            set J [expr $EnD % $ToT]
            for {  } { $I < $EnD } { incr I ; incr J } {
               set L [expr sin($pI($I))]
               set H [expr sin($pI($J))]
               set rI($N) [expr ${SgN}( $H - $L )]
               incr N
            }
         }
      }
      COS2 {
         for { set I 0 } { $I < $ToT } { } {
            set EnD [expr $I + $tE]
            set J [expr $EnD % $ToT]
            for {  } { $I < $EnD } { incr I ; incr J } {
               set dP [expr ${SgN}($pI($J) - $pI($I)) ]
               if { $dP < 0.0 } { set dP [expr $dP + $TwoPI ] }   
               set L [expr sin(2.0 * $pI($I))/4.0]
               set H [expr sin(2.0 * $pI($J))/4.0]
               set rI($N) [expr $dP/2.0 + ${SgN}( $H - $L )]
               incr N
            }
         }
      }
      SIN2 {
         for { set I 0 } { $I < $ToT } { } {
            set EnD [expr $I + $tE]
            set J [expr $EnD % $ToT]
            for {  } { $I < $EnD } { incr I ; incr J } {
               set dP [expr ${SgN}($pI($J) - $pI($I)) ]
               if { $dP < 0.0 } { set dP [expr $dP + $TwoPI ] }   
               set L [expr -sin(2.0 * $pI($I))/4.0]
               set H [expr -sin(2.0 * $pI($J))/4.0]
               set rI($N) [expr $dP/2.0 + ${SgN}( $H - $L )]
               incr N
            }
         }
      }
      COSSIN -
      SINCOS {
         for { set I 0 } { $I < $ToT } { } {
            set EnD [expr $I + $tE]
            set J [expr $EnD % $ToT]
            for {  } { $I < $EnD } { incr I ; incr J } {
               set sN [expr sin($pI($I))]
               set L [expr $sN * $sN / 2.0]
               set sN [expr sin($pI($J))]
               set H [expr $sN * $sN / 2.0]
	       set rI($N) [expr ${SgN}( $H - $L ) ]
               incr N
            }
         }
      }
      COS3 {
         for { set I 0 } { $I < $ToT } { } {
            set EnD [expr $I + $tE]
            set J [expr $EnD % $ToT]
            for {  } { $I < $EnD } { incr I ; incr J } {
               set sN [expr sin($pI($I))]
               set L [expr $sN - ($sN * $sN * $sN)/3.0]
               set sN [expr sin($pI($J))]
               set H [expr $sN - ($sN * $sN * $sN)/3.0]
	       set rI($N) [expr ${SgN}( $H - $L ) ]
               incr N
            }
         }
      }
      SIN3 {
         for { set I 0 } { $I < $ToT } { } {
            set EnD [expr $I + $tE]
            set J [expr $EnD % $ToT]
            for {  } { $I < $EnD } { incr I ; incr J } {
               set cN [expr cos($pI($I))]
               set L [expr ($cN * $cN * $cN)/3.0 - $cN]
               set cN [expr cos($pI($J))]
               set H [expr ($cN * $cN * $cN)/3.0 - $cN]
	       set rI($N) [expr ${SgN}( $H - $L ) ]
               incr N
            }
         }
      }
      COSSIN2
      SIN2COS {
         for { set I 0 } { $I < $ToT } { } {
            set EnD [expr $I + $tE]
            set J [expr $EnD % $ToT]
            for {  } { $I < $EnD } { incr I ; incr J } {
               set sN [expr sin($pI($I))]
               set L [expr ($sN * $sN * $sN)/3.0]
               set sN [expr sin($pI($J))]
               set H [expr ($sN * $sN * $sN)/3.0]
	       set rI($N) [expr ${SgN}( $H - $L ) ]
               incr N
            }
         }
      }
      COS2SIN
      SINCOS2 {
         for { set I 0 } { $I < $ToT } { } {
            set EnD [expr $I + $tE]
            set J [expr $EnD % $ToT]
            for {  } { $I < $EnD } { incr I ; incr J } {
               set cN [expr cos($pI($I))]
               set L [expr -($cN * $cN * $cN)/3.0]
               set cN [expr cos($pI($J))]
               set H [expr -($cN * $cN * $cN)/3.0]
	       set rI($N) [expr ${SgN}( $H - $L ) ]
               incr N
            }
         }
      }
   }
}
