# THIS masks a region in phase space by setting every value outside the
#    the defined mask to 0.0. The region is defined by limits in E, phi, 
#    and theta if not anchored to B otherwise there is only one phi
#    and theta which is the radius about B (+ or -)

package provide MOments 1.0

proc MOmaskData { } {
   global mANS phImG dfImG vBImG vEImG RtoD \
          thBImG thEImG eBImG eEImG MFrotM PI TwoPI

# THIS is the text window for clipping and masking

   set W .moMask.body.list
   if ![winfo exists $W] { MOguiMasks 1 }

# THIS is the number of definitions in the window

   set nF [$W index end]

# THE image sizes

   set tS  [expr $mANS(0,NSEN) * $mANS(nE)]
   set ToT [expr $tS * $mANS(Sector)]

# LOOP over the definitions and process the mask entries

   for { set Q 0 } { $Q < $nF } { incr Q } {

# READ the line

      set LiNe [$W get $Q]
      scan $LiNe "%s %f %f %f %f %f %f %f %s" \
            Type eBeg eEnd pBeg pEnd tBeg tEnd pM mInv

      set mA  [string match MASK_A $Type] 
      set mRH [string match MASK_RH $Type] 
      set mRT [string match MASK_RT $Type] 

# SET up conditions depending on whether the mask is being inverted or not

      if [string match NO $mInv] {
         set Keep 1 ; set Blank 0 ; set Cond ||
      } else { set Keep 0 ; set Blank 1 ; set Cond && }

      if { !$mA && !$mRH && !$mRT } { continue }

# GET the velocity limits and set up the Velocity Mask.  Mask is 1 if
#   the energy step is included and 0 if omitted.

      set vB $eBeg
      set vE $eEnd

      if { $eBImG(0) < $eEImG(0) } { 
         upvar 0 eBImG V1 ; upvar 0 eEImG V2
      } else { upvar 0 eBImG V2 ; upvar 0 eEImG V1 }

      for { set I 0 } { $I < $mANS(nE) } { incr I } {
         if { ($vB <= $V2($I)) && ($vE >= $V2($I)) } {
            set vMask($I) 0
         } else { set vMask($I) 1 }
      }

# MASK is either ABSOLUTE or RELATIVE.  RELATIVE clipping is wrt B
#   and ABSOLUTE is wrt to the entered limits

      if !$mA {
         set B(0) $mANS(MF0)
         set B(1) $mANS(MF1)
         set B(2) $mANS(MF2) 
         TUmatrixMath MFrotM * B TmP 3 3 3 1
         set B(0) $TmP(0)
         set B(1) $TmP(1)
         set B(2) $TmP(2)
         set pH [expr atan2($B(1), $B(0)) * $RtoD]
         set pH [expr fmod(360.0 + $pH, 360.0)]
         set XY [expr sqrt($B(0) * $B(0) + $B(1) * $B(1))]
         if $mRH {
            set tH [expr (90.0 - atan2($B(2), $XY) * $RtoD)]
         } else {
            set pH [expr fmod(180.0 + $pH, 360.0)]
            set tH [expr 180 - (90.0 - atan2($B(2), $XY) * $RtoD)]
         }
         set tB [expr ($tH - $tBeg) / $RtoD]
         set tE [expr ($tH + $tEnd) / $RtoD]
         set pB [expr fmod(($pH - $pBeg + 360.0), 360.0) / $RtoD]
         set pE [expr fmod(($pH + $pEnd + 360.0), 360.0) / $RtoD]
      } else {
         set tB [expr $tBeg / $RtoD ]
         set tE [expr $tEnd / $RtoD ]
         set pB [expr fmod(($pBeg + 360.0), 360.0) / $RtoD ]
         set pE [expr fmod(($pEnd + 360.0), 360.0) / $RtoD ]
      }   

      if { $thBImG(0) < $thEImG(0) } { 
         upvar 0 thBImG V1 ; upvar 0 thEImG V2
      } else { upvar 0 thBImG V2 ; upvar 0 thEImG V1 }

      if { $tB < 0 } { set t1 [expr -$tB] } else { set t1  0.0 }
      if { $tE > $PI } { set t2 [expr $TwoPI - $tE] } else { set t2 $PI }

      for { set I 0 } { $I < $mANS(0,NSEN) } { incr I } {
         if { ($V1($I) < $t1) || ($V2($I) > $t2) } {
            set tMask($I) 2
         } elseif { ($tB < $V2($I)) && ($tE > $V1($I)) } {
             set tMask($I) $Keep
         } else { set tMask($I) $Blank }
      }

# PHASE mask

      set nP [expr $mANS(nE) * $mANS(Sector)]

      if { $pE >= $pB } { 
         for { set I 0 } { $I < $nP } { incr I } {
            if { ($phImG($I) > $pB) && ($phImG($I) < $pE) } {
               set pMask($I) $Keep
            } else { set pMask($I) $Blank }
         }
      } else {
         for { set I 0 } { $I < $nP } { incr I } {
            if { ($phImG($I) > $pB) || ($phImG($I) < $pE) } {
               set pMask($I) $Keep
            } else { set pMask($I) $Blank }
         }
      }

#    Apply the masks to the data image.

      set N 0
      for { set I 0 } { $I < $mANS(Sector) } { incr I } {
         for { set J 0 } { $J < $mANS(0,NSEN) } { incr J } {
            set L [expr $I * $mANS(nE)]
            for { set K 0 } { $K < $mANS(nE) } { incr K ; incr L ; incr N } {
	       if { $tMask($J) == 2 } {
	          set mC [expr !$Keep]
               } else { set mC [expr !$pMask($L) $Cond !$tMask($J)] }

	       if { !$vMask($K) && $mC } { set dfImG($N) 0.0 }
            }
         }
      }
   }
}
