# Procedure does the integration over Phi.  ImG is the combined dF and
#   integrated phase arrays.  Phi is integrated over each energy step
#   for each sensor. This removes the Phi dependency from the data.

package provide MOments_C 1.0

proc MOintPhi { ImG Back } {
   global mANS 

   upvar $ImG  V
   upvar $Back rI

# tE is the number of energy steps in a sensor times the number of sensors.
#   This is the step size to get from phase element to the next in the array.

   set tE [expr $mANS(nE) * $mANS(0,NSEN)]

   for { set I 0 } { $I < $tE } { incr I } {
      set K $I
      set rI($I) 0.0
      for { set J 0 } { $J < $mANS(Sector) } { incr J ; incr K $tE } {
         set rI($I) [expr $rI($I) + $V($K)]
      }
   }
}
