# THIS procedure performs the phi integration over a set of data.
#
# FIXED:  nE    : number of steps in the data set
#         LowX  : array of the lower edges of the velocity bin
#         HighX : array of the upper edges of the velocity bin
#         CoefY : array of lists.  Each list is the coefficients of a
#                 polynomial which gives intensity across the bin

package provide MOments 1.0

proc MOintPh { nE LowX HighX CoefY Class } {

   upvar $LowX  lX
   upvar $HighX hX
   upvar $CoefY Y

# INITIALIZE the upper an lower integration summations
                                                                                
   set SumH 0.0
   set SumL 0.0
                                                                                
# THIS is the number of polynomial coefficients defined in computing the
#   intensity across the bin.
                                                                                
   set nC [llength $Y(0)]

# SET up the signs in the final combination.
                                                                                
   if { $lX(0) < $hX(0) } {
      set SgNL - ; set SgNH +
   } else { set SgNL + ; set SgNH - }
                                                                                
   switch -exact -- $Class {

      FIXED {
         for { set I 0 } { $I < $nE } { incr I } {
            set SumL [expr $SumL + $Y($I) * $lX($I)]
            set SumH [expr $SumH + $Y($I) * $hX($I)]
         }
      }
      SIN {
         for { set I 0 } { $I < $nE } { incr I } {
            set SumL [expr $SumL - $Y($I) * cos($lX($I))]
            set SumH [expr $SumH - $Y($I) * cos($hX($I))]
         }
      }
      COS {
         for { set I 0 } { $I < $nE } { incr I } {
            set SumL [expr $SumL + $Y($I) * sin($lX($I))]
            set SumH [expr $SumH + $Y($I) * sin($hX($I))]
         }
      }
   }

   set rV [expr $SgNH$SumH $SgNL $SumL ]
                                                                                
   return $rV
}
