# THIS procedure puts up a clip definition gui
                                                                                
package provide MOments 1.0
                                                                                
proc MOguiMasks { { ImC 0 } } {
   global env mANS Prefs


   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set W .moMask
   set LaB "MASKS AND CLIPS"

   MOallInits MASKS
   if [GUIWindow $W $LaB] {

      if $ImC { GUIwindowCtrl $W }

      set Wa $W.top
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wc -1 grid|1|0|news
      GUIFrame $Wd -1 grid|2|0|news
      GUIFrame $We -1 grid|3|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      set R 0

      set LaBa [format $mANS(MaskslfA) Energy Phi Theta]
      set LaBb [format $mANS(MASKS,lf) Type Min Max Min Max Min Max %Max Inv]

      incr R 
      GUILabel $Wc.t$R $LaBa  w grid|$R|0|w 0 0 "" $CFonT
      incr R 
      GUILabel $Wc.t$R $LaBb  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 55 7  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "MOaddItem MASKS F" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "MOeditItem MASKS F" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "MOaddItem MASKS F REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "MOtwinCmd $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "MOvarReset MASKS" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "MOtwinCmd $W DELETE" 6

      set R 0
      GUIblankRow $We $R 2.5

      set OpsA [list CLIP_A CLIP_R MASK_A MASK_RT MASK_RH]
      set OpsB [list YES NO]

      incr R 
      GUIblankCol $We 0 1
      GUILabel $We.t$R  "Type" w grid|$R|0|w -1 0 "" $LFonT
      GUIbuttonMenu $We.mt $mANS(mFmT) grid|$R|1|w $OpsA  \
                         "GUIoptsProcess $We.mt mANS(mFmT) PRI " 6

      incr R 
      GUIblankRow $We $R 1.0

      incr R 
      GUILabel $We.l1 Start c grid|$R|1 0 -1 "" $LFonT
      GUILabel $We.l2 Stop  c grid|$R|2 0 -1 "" $LFonT

      incr R 
      GUILabel $We.t$R "Energy" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $We.minE grid|$R|1| 8 mANS(mbEv)
      GUIboxEntry $We.maxE grid|$R|2| 8 mANS(meEv)
      GUILabel $We.et$R eV w grid|$R|3

      incr R 
      GUILabel $We.t$R "Phi" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $We.minP grid|$R|1| 8 mANS(mbPh)
      GUIboxEntry $We.maxP grid|$R|2| 8 mANS(mePh)
      GUILabel $We.et$R deg w grid|$R|3

      incr R 
      GUILabel $We.t$R "Theta" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $We.minT grid|$R|1| 8 mANS(mbTh)
      GUIboxEntry $We.maxT grid|$R|2| 8 mANS(meTh)
      GUILabel $We.et$R deg w grid|$R|3

      incr R 
      GUILabel $We.t$R "% Max" w grid|$R|0|w 0 -1 "" $LFonT
      GUIboxEntry $We.pc grid|$R|1| 8 mANS(pcClip)

      incr R
      GUILabel $We.t$R "Invert" w grid|$R|0|w 0 -1 "" $LFonT
      GUIbuttonToggle $We.inv $mANS(mInv) grid|$R|1 $OpsB \
                     "GUIoptsToggle $We.inv mANS(mInv) PRI" 0,0.5

      bind $W <Down> { MOtwinCmd %W MOVE DOWN }
      bind $W <Up> { MOtwinCmd %W MOVE UP }

      MOallInits  MASKS
      if [info exists mANS(MASKS,rd)] { MOfillFLBox MASKS }
      MOfillGUI MASKS 

   } else { GUIwindowCtrl $W }
}
