# THIS procedure contains the MOments GUI front end.  The moments GUI is
# based on the GUI used in the UDFAnalysis package.
                                                                                
package provide MOments 1.0
                                                                                
proc MOguiMain { } {
   global env mANS Prefs

# READ in the preference file

   GUIprefsRead

# SET up some basic fonts to use

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]

   if ![winfo exists .moTOP] {

      . configure -bg $Prefs(FBgCol)

      set Wa .moTOP
      set Wb .moMENU
      set Wc .moBODY

      GUIFrame $Wa -1 pack|top||both
      GUIFrame $Wb -1 pack|top||both
      GUIFrame $Wc -1 pack|left||both

      GUIFrame $Wa.a -1 pack|left||both
      GUIFrame $Wa.b -1 pack|left||both
      GUIFrame $Wa.c -1 pack|right||both
      
      GUIbuttonPush $Wa.a.run  PROCESS  pack|left "MOprocessReq" 6
      GUILabel $Wa.b.acta "" c pack|top 12 36
      GUILabel $Wa.b.actb "" c pack|top 12 36
      GUIbuttonPush $Wa.c.quit QUIT pack|right "exit"  6

      set R 0
      GUILabel $Wb.lim "Input Menu" e grid|$R|0|e 0 0 "" $LFonT
      GUIboxEntry $Wb.im grid|$R|1|news 40 mANS(MenuRead)
      GUIbuttonPush $Wb.load  LOAD  grid|$R|2|e "MOmenuRead" 0,0.5

      incr R
      GUILabel $Wb.lsm "Save Menu" e grid|$R|0|e 0 0 "" $LFonT
      GUIboxEntry $Wb.sm grid|$R|1|news 40 mANS(MenuSave) 
      GUIbuttonPush $Wb.save  SAVE  grid|$R|2|e "MOmenuSave" 0,0.5

      incr R
      GUILabel $Wb.lou "Output To" e grid|$R|0|e 0 0 "" $LFonT
      GUIboxEntry $Wb.ou grid|$R|1|news 40 mANS(OutRes) 

      set R 0
      GUIblankRow $Wc $R 2.0

      incr R
      GUILabel $Wc.mlab "MENUS" c grid|$R|0 10 0 "" $LFonT
      GUIbuttonPush $Wc.time "TIME DEFINITION" grid|$R|1 "MOguiTime" 6

      incr R
      GUIbuttonPush $Wc.src "VARIABLE DEFINITIONS" grid|$R|1 "MOguiVar" 6

      incr R
      GUIbuttonPush $Wc.ir "SETUP DEFINITIONS" grid|$R|1 "MOguiLimits" 6

      incr R
      GUIbuttonPush $Wc.cut "MASK DEFINITIONS" grid|$R|1 "MOguiMasks" 6
   }

   update
   bind .moMENU.im <Return> { .moMENU.sm delete 0 end ; \
                                    .moMENU.sm insert end "$mANS(MenuRead)"}
}
