# THIS procedure reads a moments file created by the moments program

package provide MOments 1.0

proc MOgetMData { MoM rV { FaC 1.0 }  } {
   global iMOM 

   upvar $rV mV

   switch -exact -- $MoM {
      N   { set oA 6 ; set iD N }
      VX  { set oA 7 ; set iD V }
      VY  { set oA 8 ; set iD V }
      VZ  { set oA 9 ; set iD V }
      EX  { set oA 10 ; set iD E }
      EY  { set oA 13 ; set iD E }
      EZ  { set oA 15 ; set iD E }
      F1  { set oA 26 ; set iD F }
      F2  { set oA 27 ; set iD F }
      F3  { set oA 28 ; set iD F }
      F4  { set oA 29 ; set iD F }
      F5  { set oA 30 ; set iD F }
      F6  { set oA 31 ; set iD F }
      F7  { set oA 32 ; set iD F }
      F8  { set oA 33 ; set iD F }
      F9  { set oA 34 ; set iD F }
      F10 { set oA 35 ; set iD F }
      BYR { set oA 0  ; set iD TM }
      BDY { set oA 1  ; set iD TM }
      BMS { set oA 2  ; set iD TM }
      EYR { set oA 3  ; set iD TM }
      EDY { set oA 4  ; set iD TM }
      EMS { set oA 5  ; set iD TM }
      TXX { set oA 10 ; set oB 7 ; set oC 7 ; set iD T }
      PXX { set oA 10 ; set oB 7 ; set oC 7 ; set iD P }
      TXY -
      TYX { set oA 11 ; set oB 7 ; set oC 8 ; set iD T }
      PXY -
      PYX { set oA 11 ; set oB 7 ; set oC 8 ; set iD P }
      TXZ -
      TZX { set oA 12 ; set oB 7 ; set oC 9 ; set iD T }
      PXZ -
      PZX { set oA 12 ; set oB 7 ; set oC 9 ; set iD P }
      TYY { set oA 13 ; set oB 8 ; set oC 8 ; set iD T }
      PYY { set oA 13 ; set oB 8 ; set oC 8 ; set iD P }
      TYZ -
      TZY { set oA 14 ; set oB 8 ; set oC 9 ; set iD T }
      PYZ -
      PZY { set oA 14 ; set oB 8 ; set oC 9 ; set iD P }
      TZZ { set oA 15 ; set oB 9 ; set oC 8 ; set iD T }
      PZZ { set oA 15 ; set oB 9 ; set oC 8 ; set iD P }
      QXX { set oA 16 ; set oB 10 ; set oC 10 ; set oD 7; set oE 7 ; set iD Q }
      QXY { set oA 17 ; set oB 10 ; set oC 11 ; set oD 7; set oE 8 ; set iD Q }
      QXZ { set oA 18 ; set oB 10 ; set oC 12 ; set oD 7; set oE 9 ; set iD Q }
      QYX { set oA 19 ; set oB 13 ; set oC 11 ; set oD 8; set oE 7 ; set iD Q }
      QYY { set oA 22 ; set oB 13 ; set oC 13 ; set oD 8; set oE 8 ; set iD Q }
      QYZ { set oA 23 ; set oB 13 ; set oC 13 ; set oD 8; set oE 8 ; set iD Q }
      QZX { set oA 21 ; set oB 15 ; set oC 12 ; set oD 9; set oE 7 ; set iD Q }
      QZY { set oA 24 ; set oB 15 ; set oC 14 ; set oD 9; set oE 8 ; set iD Q }
      QZZ { set oA 25 ; set oB 15 ; set oC 15 ; set oD 9; set oE 9 ; set iD Q }
   }

   set nM [llength $iMOM(vMOM)]

   switch -exact -- $iD {
      N {
         set mB $FaC
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $iMOM(vMOM) $I]
	    set mV($I) [lindex $V $oA]
	 }
      }
      V {
         set mB $FaC
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $iMOM(vMOM) $I]
	    set mV($I) [lindex $V $oA]
	 }
      }
      T {
         set mB [expr $FaC * 2.0 / $iMOM(toV) / 3.0]
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $iMOM(vMOM) $I]
	    set Vij [lindex $V $oA]
	    set Vi  [lindex $V $oB]
	    set Vj  [lindex $V $oC]
	    set mV($I) [expr $Vij - $Vi * $Vj]
	 }
      }
      P {
         set mB [expr $FaC * $iMOM(Mass)]
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $iMOM(vMOM) $I]
	    set D [lindex $iMOM(vMOM) 6]
	    set Vij [lindex $V $oA]
	    set Vi  [lindex $V $oB]
	    set Vj  [lindex $V $oC]
	    set mV($I) [expr $D * ($Vij - $Vi * $Vj)]
	 }
      }
      Q {
         set mB [expr $FaC / $iMOM(toV)]
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $iMOM(vMOM) $I]
	    set Viij [lindex $V $oA]
	    set Vii  [lindex $V $oB]
	    set Vij  [lindex $V $oC]
	    set Vi   [lindex $V $oD]
	    set Vj   [lindex $V $oE]
	    set mV($I) [expr $Viij - 2.0 * $Vij * $Vi - $Vii * $Vj + \
	                   $Vi * $Vi * $Vj]
	 }
      }
      E {
         set mB [expr $FaC / $iMOM(toV)]
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $iMOM(vMOM) $I]
	    set mV($I) [lindex $V $oA]
	 }
      }
      F {
         set mB $FaC 
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $iMOM(vMOM) $I]
	    set mV($I) [lindex $V $oA]
	 }
      }
      TM {
         set mB $FaC 
         for { set  I 0 } { $I < $nM } { incr I } {
	    set V [lindex $iMOM(vMOM) $I]
	    set mV($I) [lindex $V $oA]
	 }
      }
   }


# GET to units 

   if { $mB != 1.0 } {
      for { set  I 0 } { $I < $nM } { incr I } {
          set mV($I) [expr $mB * $mV($I)]
      }
   }

   return $nM
}
