# THIS procedure combines a DF ImG with an Phase ImG
#
# INPUT:  ImGA : phase ImG
#         ImGB : dF ImG
#         Back : the returned ImG

package provide MOments 1.0

proc MOcombineImG { ImGA ImGB Back } {

   upvar $ImGA aI
   upvar $ImGB bI
   upvar $Back rI

# THESE are Image sizes

   set nA [array size aI]
   set nB [array size bI]

# SINCE the images may not be the same size we need to compute a repitition
#   factor which if not an integral number will cause the program to abort

   if { $nA > $nB } {
      set ReP [expr int($nA / $nB)]
      set fR [expr $nA % $nB]
      if { $fR != 0 } { return 0 }
      for { set I 0 ; set K 0 } { $I < $ReP } { incr I } {
         for { set J 0 } { $J < $nB } { incr J ; incr K } {
            set rI($K) [expr $aI($K) * $bI($J)]
         }
      }
   } elseif { $nA < $nB } {
      set ReP [expr int($nB / $nA)]
      set fR [expr $nB % $nA]
      if { $fR != 0 } { return 0 }
      if { $DiM == 1 } {
         for { set I 0 ; set K 0 } { $I < $ReP } { incr I } {
            for { set J 0 } { $J < $nA } { incr J ; incr K } {
               set rI($K) [expr $aI($J) * $bI($K)]
            }
         }
      } else { 
         set bSz [expr int($nA/$ReP)]
         for { set I 0 ; set K 0 } { $I < $ReP } { incr I } {
            for { set J 0 } { $J < $nA } { incr J ; incr K } {
               for { set L 0 } { $L < $bSz } { incr J ; incr K } {
                   set rI($K) [expr $aI($J) * $bI($K)]
               }
            }
         }
      }
   } else { 
      for { set I 0 } { $I < $nA } { incr I } {
         set rI($I) [expr $aI($I) * $bI($I)]
      }
   } 
   return 1
}
