#include <tcl.h>

int IntPhi (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int IntTh (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int IntVel (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int LinearElements (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int LinearIntPh (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int MassIntTh (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int MassIntVel (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int PhiDfImg (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int ThDfImg (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int VelDfImg (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int Tclmoments_Init (Tcl_Interp *interp) {
   Tcl_CreateObjCommand (interp, "MOintPhi", IntPhi, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "MOintTheta", IntTh, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "MOintVel", IntVel, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "MOlinearElements", LinearElements, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "MOlinearintPh", LinearIntPh, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "MOmassintTh", MassIntTh, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "MOmassintVel", MassIntVel, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "MOphidfImG", PhiDfImg, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "MOthdfImG", ThDfImg, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "MOveldfImG", VelDfImg, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_PkgProvide(interp, "MOments_C",  "2.0");

   return TCL_OK;
}
