/*  The C equivalent of MOmassintTh. It consists straight C interface.      */
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Lower Theta Bin Limits                                     */
/*     OBJV[2]:  Upper Theta Bin Limits                                     */
/*     OBJV[3]:  Return integral                                            */
/*     OBJV[4]:  Trig Function to integrate over                            */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TmomentAnsi.h"
#include "TutilAnsi.h"

int MassIntTh (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   ReaL_8 L, H, P, V, SgN; 
   ByTe_4 I;
   int    nT;
   ByTe_2 trigV = 0;
   ByTe_1 *Trig;

   char Index[10];
   char *lName, *hName, *rName;
   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *rVO, *rV1;

/* MAKE sure that all the IO parameters are present                      */

   if (objc != 5 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: MOmassintTh Low High Back Trig");
     return TCL_ERROR;
   }

   rV1 = Tcl_NewObj();

/* GET the inegration order                                              */
 
   Trig = Tcl_GetStringFromObj (objv[4], (int *)0);

/* Get the Trig string to a value                                        */

   if ( strcmp("SIN",Trig) == 0 ) {
      trigV = 0;
   } else if ( strcmp("SIN2",Trig) == 0 ) {
      trigV = 1;
   } else if ( strcmp("SINCOS",Trig) == 0 ) {
      trigV = 2;
   } else if ( strcmp("COSSIN",Trig) == 0 ) {
      trigV = 2;
   } else if ( strcmp("SIN3",Trig) == 0 ) {
      trigV = 3;
   } else if ( strcmp("SIN2COS",Trig) == 0 ) {
      trigV = 4;
   } else if ( strcmp("COSSIN2",Trig) == 0 ) {
      trigV = 4;
   } else if ( strcmp("SINCOS2",Trig) == 0 ) {
      trigV = 5;
   } else if ( strcmp("COS2SIN",Trig) == 0 ) {
      trigV = 5;
   } else if ( strcmp("SIN4",Trig) == 0 ) {
      trigV = 6;
   } else if ( strcmp("SINCOS3",Trig) == 0 ) {
      trigV = 7;
   } else if ( strcmp("COS3SIN",Trig) == 0 ) {
      trigV = 7;
   } else if ( strcmp("SIN3COS",Trig) == 0 ) {
      trigV = 8;
   } else if ( strcmp("COSSIN3",Trig) == 0 ) {
      trigV = 8;
   } else if ( strcmp("SIN2COS2",Trig) == 0 ) {
      trigV = 9;
   } else if ( strcmp("COS2SIN2",Trig) == 0 ) {
      trigV = 9;
   }

/* GET the global information we'll need                                 */

   Tcl_UpVar(tI, "#0", "mANS", "mAnS", 0);
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "0,NSEN", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nT);
   }

/* GET the input array names                                             */

   lName = Tcl_GetStringFromObj(objv[1], (int *)0);
   hName = Tcl_GetStringFromObj(objv[2], (int *)0);
   rName = Tcl_GetStringFromObj(objv[3], (int *)0);

   rVO = Tcl_GetVar2Ex(tI, lName, "0", Flg);
   Tcl_GetDoubleFromObj (tI, rVO, &L);
   rVO = Tcl_GetVar2Ex(tI, hName, "0", Flg);
   Tcl_GetDoubleFromObj (tI, rVO, &H);

   SgN = (L < H) ? 1.0 : -1.0;

   switch (trigV) {
      case 0:
	 for (I = 0; I < nT; ++I) {
            sprintf(Index, "%d", I);
            rVO = Tcl_GetVar2Ex(tI, lName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    L = -cos(P);
            rVO = Tcl_GetVar2Ex(tI, hName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    H = -cos(P);

	    V = SgN * (H - L);

	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
      case 1:
	 for (I = 0; I < nT; ++I) {
            sprintf(Index, "%d", I);
            rVO = Tcl_GetVar2Ex(tI, lName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P *= 2.0;
	    L = (P - sin(P))/4.0;
            rVO = Tcl_GetVar2Ex(tI, hName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P *= 2.0;
	    H = (P - sin(P))/4.0;

	    V = SgN * (H - L);

	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
      case 2:
	 for (I = 0; I < nT; ++I) {
            sprintf(Index, "%d", I);
            rVO = Tcl_GetVar2Ex(tI, lName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = sin(P);
	    L = (P * P)/2.0;
            rVO = Tcl_GetVar2Ex(tI, hName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = sin(P);
	    H = (P * P)/2.0;

	    V = SgN * (H - L);

	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
      case 3:
	 for (I = 0; I < nT; ++I) {
            sprintf(Index, "%d", I);
            rVO = Tcl_GetVar2Ex(tI, lName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = cos(P);
	    L = (P * P * P)/3.0 - P;
            rVO = Tcl_GetVar2Ex(tI, hName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = cos(P);
	    H = (P * P * P)/3.0 - P;

	    V = SgN * (H - L);

	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
      case 4:
	 for (I = 0; I < nT; ++I) {
            sprintf(Index, "%d", I);
            rVO = Tcl_GetVar2Ex(tI, lName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = sin(P);
	    L = (P * P * P)/3.0;
            rVO = Tcl_GetVar2Ex(tI, hName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = sin(P);
	    H = (P * P * P)/3.0;

	    V = SgN * (H - L);

	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
      case 5:
	 for (I = 0; I < nT; ++I) {
            sprintf(Index, "%d", I);
            rVO = Tcl_GetVar2Ex(tI, lName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = cos(P);
	    L = -(P * P * P)/3.0;
            rVO = Tcl_GetVar2Ex(tI, hName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = cos(P);
	    H = -(P * P * P)/3.0;

	    V = SgN * (H - L);

	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
      case 6:
	 for (I = 0; I < nT; ++I) {
            sprintf(Index, "%d", I);
            rVO = Tcl_GetVar2Ex(tI, lName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P *= 2.0;
	    L = 3.0 * P/16.0 - sin(P)/4.0 + sin(2.0 * P)/32.0;
            rVO = Tcl_GetVar2Ex(tI, hName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P *= 2.0;
	    H = 3.0 * P/16.0 - sin(P)/4.0 + sin(2.0 * P)/32.0;

	    V = SgN * (H - L);

	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
      case 7:
	 for (I = 0; I < nT; ++I) {
            sprintf(Index, "%d", I);
            rVO = Tcl_GetVar2Ex(tI, lName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = cos(P);
	    L = -(P * P * P * P)/4.0;
            rVO = Tcl_GetVar2Ex(tI, hName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = cos(P);
	    H = -(P * P * P * P)/4.0;

	    V = SgN * (H - L);

	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
      case 8:
	 for (I = 0; I < nT; ++I) {
            sprintf(Index, "%d", I);
            rVO = Tcl_GetVar2Ex(tI, lName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = sin(P);
	    L = (P * P * P * P)/4.0;
            rVO = Tcl_GetVar2Ex(tI, hName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P = sin(P);
	    H = (P * P * P * P)/4.0;

	    V = SgN * (H - L);

	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
      case 9:
	 for (I = 0; I < nT; ++I) {
            sprintf(Index, "%d", I);
            rVO = Tcl_GetVar2Ex(tI, lName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P *= 4.0;
	    L = (P - sin(P))/32.0;
            rVO = Tcl_GetVar2Ex(tI, hName, Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &P);
	    P *= 4.0;
	    H = (P - sin(P))/32.0;

	    V = SgN * (H - L);

	    rV1 = Tcl_DuplicateObj(rV1);
	    Tcl_SetDoubleObj (rV1, V);
	    Tcl_SetVar2Ex(tI, rName, Index, rV1, Flg);
         }
      break;
   }

   return TCL_OK;
}
