/*  The C equivalent of MOlinearintPh. It consists straight C               */
/*  a straight C interface.                                                 */
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Lower band limits                                          */
/*     OBJV[2]:  Upper band limits                                          */
/*     OBJV[3]:  Return integral                                            */
/*     OBJV[4]:  Integral order                                             */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TmomentAnsi.h"
#include "TutilAnsi.h"

int LinearElements (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   ReaL_8 dfN, dfNn, phI, phIn; 
   ReaL_8 vA, vB; 
   ByTe_4 N, pB, pE, sE, pT, dT;
   ByTe_4 I, J, K;
   ByTe_4 iN, nN;
   int    nE, nS, nT;

   char Index[10];
   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *rVO, *rV1;
  
/* MAKE sure that all the IO parameters are present                      */

   if (objc != 1 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: MOlinearElements");
     return TCL_ERROR;
   }

/* GET the global information we'll need                                 */

   Tcl_UpVar(tI, "#0", "mANS", "mAnS", 0);
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "0,NSEN", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nT);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "nE", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nE);
   }
   if ( (rVO = Tcl_GetVar2Ex(tI, "mAnS", "Sector", Flg)) != NULL) {
      Tcl_GetIntFromObj (tI, rVO, &nS);
   }

/* ESTABLISH the global array names                                      */

   Tcl_UpVar(tI, "#0", "phImG", "pI", 0);
   Tcl_UpVar(tI, "#0", "dfImG", "dI", 0);
   Tcl_UpVar(tI, "#0", "slImG", "sI", 0);
   Tcl_UpVar(tI, "#0", "inImG", "iI", 0);
   rV1 = Tcl_NewObj();

/* INITIALIZE index pointers                                             */

   N = 0;
   pB = 0;
   pE = nE;
   sE = nE * nT;

   pT = nE * nS;
   dT = nE * nS * nT;
  
/* DO the integrations                                                   */

   for ( K = 0; K < nS; ++K, pB += nE, pE += nE ) {
      for ( J = 0; J < nT; ++J ) {
         for ( I = pB; I < pE; ++I, ++N ) {
            iN = (I + nE) % pT;
            nN = (N + sE) % dT;

            sprintf(Index, "%d", I);
            rVO = Tcl_GetVar2Ex(tI, "pI", Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &phI);

            sprintf(Index, "%d", iN);
            rVO = Tcl_GetVar2Ex(tI, "pI", Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &phIn);

            sprintf(Index, "%d", nN);
            rVO = Tcl_GetVar2Ex(tI, "dI", Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &dfNn);

            sprintf(Index, "%d", N);
            rVO = Tcl_GetVar2Ex(tI, "dI", Index, Flg);
            Tcl_GetDoubleFromObj (tI, rVO, &dfN);

	    vA = (dfN - dfNn) / (phI - phIn);
	    vB = dfN - vA * phI;

            rV1 = Tcl_DuplicateObj(rV1);
            Tcl_SetDoubleObj (rV1, vA);
            Tcl_SetVar2Ex(tI, "sI", Index, rV1, Flg);
            rV1 = Tcl_DuplicateObj(rV1);
            Tcl_SetDoubleObj (rV1, vB);
            Tcl_SetVar2Ex(tI, "iI", Index, rV1, Flg);
         }
      }
   }

   return TCL_OK;
}
