# THIS procedure will output a GUI menu which contains all of the necessary
#    options to fully select a UDF or IDFS data source.  It includes 
#    the selection of UDF lineage of the measurement and its units, 
#    and a collapse method should that be needed.  It also allows the 
#    sensor definitions associated with the UDF to be increased and decreased
#    dynamically.  The routine works only in pop-up mode.
#
#  Ops Array
#
#    0 : Label position B(ottom) T(op) R(ight) L(eft) N(one)
#    1 : UNUSED:  THIS MENU HAS NO HORIZONTAL OUTPUT OPTION!
#    2 : The size of the response option widgets
#    3 : Prefix preappend to answer index as $oPs(3),xxx
#    4 : Unused
#    5 : Whether or not to put up a top level label over the options
#
#  INPUTS  
#    W       - An existing window number if this is to be put into a
#              defined window or a undefined window if this routine
#              should pop up its own base window.
#    uOps    list  
#            FonT - The Label Font
#            WithDel - Include Delete Button
#            WithAdd - Include Add Source Button
#            GFmt - Menu Position
#                 OU - Over Under
#            TwoArray - Include two array measurement options

package provide GUIUtils 1.0

proc GUudfSrc { W Title AddCol iD rInFo uOps } {
 
# THIS is the definition of the filled in option array
   
   set TheSrc $rInFo
   global [set TheSrc ]
                                                                                
   upvar [set TheSrc] rI
   upvar $uOps uO

   if ![info exists uO(Font)]     { set uO(Font) "" } 
   if ![info exists uO(WithDel)]  { set uO(WithDel) NO }
   if ![info exists uO(WithAdd)]  { set uO(WithAdd) NO }
   if ![info exists uO(GFmt)]     { set uO(GFmt) OU }
   if ![info exists uO(TwoArray)] { set uO(TwoArray) NO }

   set FonT $uO(Font)

# IF the window doesn't exist assume that this is to be a top level window.
#   Otherwise it is a frame into which we will embed the buttons.

   if ![winfo exists $W] { toplevel $W ; wm title $W $Title }

# SET up the mandatory frames

   set Wa $W.mTOP
   set Wb $W.mUDF
   set Wc $W.mAdd
   set Wd $W.mMEA0

   if [string match OU $uO(GFmt)] {
      GUIFrame $Wa -1 grid|0|0|news||2
      GUIFrame $Wb -1 grid|1|0|news
      if [string match YES $uO(WithAdd)] { GUIFrame $Wc -1 grid|1|1|news }
      GUIFrame $Wd -1 grid|2|0|news
   } else {
      GUIFrame $Wa -1 grid|0|0|news||3
      GUIFrame $Wb -1 grid|1|0|news
      GUIFrame $Wd -1 grid|1|1|news
      set uO(WithAdd) NO
   }

# Save the overall title, and any options we may need down the line

   set rI($iD,Opened)   1
   set rI($iD,Title)    $Title
   set rI($iD,AddCol)   $AddCol
   set rI($iD,WithDel)  $uO(WithDel)
   set rI($iD,WithAdd)  $uO(WithAdd)
   set rI($iD,GFmt)     $uO(GFmt)
   set rI($iD,TwoArray) $uO(TwoArray)

# ADD the collapse frames if we need to

   if [string match YES $rI($iD,AddCol)] {
      set We $W.mCOL0
      if [string match OU $uO(GFmt)] {
         GUIFrame $We -1 grid|2|1|news
      } else { GUIFrame $We -1 grid|1|2|news }

      set rI($iD,cW) $We
   } else { set rI($iD,cW) NULL }

# THESE are the locations of the measurement and freeze frames

   set rI($iD,dW) $Wd
   set rI($iD,fW) $Wc.fW

# THIS is a list of sensor definitions under this window.  The first one is
#   set up in the routine but you can add to the list through the ADD SENSOR
#   option

   if ![info exists rI($iD,SenL)] { set rI($iD,SenL) [list 1] }

# STORE the font info if none exists

   if ![info exists rI($iD,mF)] { set rI($iD,mF) $FonT }

# Break out all of the font bits

   set nF [llength $FonT]
   set mF [lindex $FonT 0]
   if { $nF > 1 } { set lF [lindex $FonT 1] } else { set lF $mF }
   if { $nF > 2 } { set lCol [lindex $FonT 2] } else { set lCol #000000 }

   set ftOps [list THAW|0 FREEZE|1]
   if ![info exists rI($iD,fWV)] { set rI($iD,fWV) 0 } 

   set LaB [lindex [split [lindex $ftOps $rI($iD,fWV)] "|"] 0]
   GUIbuttonToggle $Wa.fW $LaB pack|left|w $ftOps \
          "GUsetOpts $Wa.fW $rInFo $iD,fWV ALT TOGGLE" 0 10 "" "" $mF

   GUILabel $Wa.lab $Title c pack|left|center|x|true \ 6 -1 $lCol $lF
   if [string match YES $uO(WithDel)] {
      GUIbuttonPush $Wa.del "DELETE" pack|right|e \
           "GUdelUdfSrc $W $rInFo $iD" 6 0 "" "" "" $mF 
   }

   if [string match YES $uO(WithAdd)] { 
      GUIbuttonPush $Wc.add "ADD SENSOR" pack|bottom|e \
                     "GUaddSensor $W $iD $rInFo" 6 0 "" "" "" $mF
   }

   set oP(0) N
   set oP(1) V
   set oP(3) $iD
   set oP(5) YES

   GUudfPMEIV $Wb $rInFo oP $FonT

   set oP(2) -1
   GUudfDataSrc $Wd $rInFo oP $FonT
   if [string match YES $rI($iD,AddCol)] { GUudfCollapse $We $rInFo oP $FonT }
}
