# THIS procedure will output a set of 5 horizontal or vertical menu buttons
#    which allows for the selection of a UDF lineage tree 
#
#  Ops Array
#
#    0 : Label position B(ottom) T(op) R(ight) L(eft) N(one) 
#    1 : Stack H(orizontally) or V(ertically) 
#    2 : Number PMEIV definitions to show
#    3 : The array iD
#    4 : Sticky (news, w, e, etc)
#    5 : Add Top Label
#    6 : Freeze any input PMEIV ... (NO YES)
#
#   The procedure provides through selections:
#
#    PmeiV($Ops(3),M) : A UDF mission acronym
#    PmeiV($Ops(3),E) : A UDF experiment acronym
#    PmeiV($Ops(3),I) : A UDF instrument acronym
#    PmeiV($Ops(3),V) : A UDF virtual instrument acronym
#
#   Preset values needed if GUudfDataSrc and GUudfCollapse are called
#
#    PmeiV($Ops(3),dW) : list of dependent data windows (| separated)
#    PmeiV($Ops(3),cW) : list of collapse windows (| separated)
#
#   Preset value needed a freeze button is included
#
#    PmeiV($Ops(3),fW) : freeze window

package provide GUIUtils 1.0

proc GUudfPMEIV { W rInFo Ops { FonT "" } } {

   set TheSrc $rInFo
   global [set TheSrc ]

   upvar [set TheSrc] rI
   upvar $Ops wO

# SET up default options for those not established.
 
   GUudfInits OPS wO NULL 0 DEFINED

# IF the window doesn't exist assume that this is to be a top level window.
#   Otherwise it is a frame into which we will embed the buttons.

   if ![winfo exists $W] { toplevel $W }

   set wLb [list PROJECT MISSION EXPERIMENT INSTRUMENT VIRTUAL]
   set wID [list project mission exper inst vinst]
   set aID [list P M E I V]

# INITIAL INITS

   set bN $wO(3)
   GUudfInits PMEIV $rInFo $bN 0 DEFINED

# STORE the font info if none exists

   if ![info exists rI($bN,mF)] { 
      set rI($bN,mF) $FonT 
   } else { set FonT $rI($bN,mF) }

# Break out all of the font bits

   set nF [llength $FonT]
   set mF [lindex $FonT 0]
   if { $nF > 1 } { set lF [lindex $FonT 1] } else { set lF $mF }
   if { $nF > 2 } { set lCol [lindex $FonT 2] } else { set lCol #FF0000 }
   if ![info exists rI($bN,mF)] { set rI($bN,mF) [lindex $mF 0] }

# SET up the lineage array

   set PmEiV(P) $rI($bN,P)
   set PmEiV(M) $rI($bN,M)
   set PmEiV(E) $rI($bN,E)
   set PmEiV(I) $rI($bN,I)
   set PmEiV(V) $rI($bN,V)

   set dR 0
   set dC 0
   switch -exact -- $wO(0) {
      N  {  set lR 0 ; set bR 0 ; set lC 0 ; set bC 0 ; set lP w 
            if { $wO(1) == "V" } { 
               set dR 1 ; set tLs 1 
            } else { set dC 1 ; set tLs 5 }
         }
      L  {  set lR 0 ; set bR 0 ; set lC 0 ; set bC 1 ; set lP w
            if { $wO(1) == "V" } { set dR 1 } else { set dC 2 }
         }
      R  {  set lR 0 ; set bR 0 ; set lC 1 ; set bC 0 ; set lP w 
            if { $wO(1) == "V" } { set dR 1 } else { set dC 2 }
         }
      T  {  set lR 0 ; set bR 1 ; set lC 0 ; set bC 0 ; set lP ew 
            if { $wO(1) == "V" } { set dR 2 } else { set dC 1 }
         }
      B  {  set lR 1 ; set bR 0 ; set lC 0 ; set bC 0 ; set lP ew
            if { $wO(1) == "V" } { set dR 2 } else { set dC 1 }
         }
   }

# OUTPUT a header label if we are supposed to.  Make it red and bold

   if [string match YES $wO(5)] { 
      set LaB "UDF SOURCE"
      GUILabel $W.ltop $LaB c grid|0|0|news||5||5 0 -1 $lCol $lF
      incr lR ; incr bR
   }

# Stick the whole thing into a single frame of the users choice.

   set lCmD [list DBudfLineage ]
   set First 1
   for { set I 0 } { $I < $wO(2) } { incr I } {
      set wEx [lindex $wID $I]
      set LaB [lindex $wLb $I]
      set Src [lindex $aID $I]

      set sL [string length $PmEiV($Src)]
      if { $sL == 0 } { 
         set C #0000FF
         if $First { eval set uO \[ $lCmD \] ; set First 0 } else { set uO "" }
      } else {
         set C #000000
         eval set uO \[ $lCmD \]
         lappend lCmD $PmEiV($Src)
      }

      if [string match N $wO(0)] { 
         if { $sL == 0 } { set bLaB $LaB } else { set bLaB $PmEiV($Src) }
         GUIbuttonMenu $W.$wEx "" grid|$bR|$bC|news $uO  \
           "GUudfOpts $W $rInFo $wO(3) $Src " 6 15 "" "" "" $mF
         $W.$wEx configure -text $bLaB -fg $C -activeforeground $C
      } else {
         if { $sL == 0 } { set bLaB "" } else { set bLaB $PmEiV($Src) }
         GUILabel $W.l$wEx $LaB $lP grid|$lR|$lC|news 3 12 #000000
         GUIbuttonMenu $W.$wEx $bLaB grid|$bR|$bC|$lP $uO  \
           "GUudfOpts $W $rInFo $wO(3) $Src " 6 15 "" "" "" $mF
      }
      if { ($sL > 0) && [string match YES $wO(6)] } {
          GUIstateSet  $W.$wEx MBUTTON disabled
      }

      incr lR $dR
      incr bR $dR
      incr lC $dC
      incr bC $dC
   }
}
