# INPUTS
#
#   W :  The base widget window

package provide GUIUtils 1.0

proc GUudfOpts { W rInFo bN Src Index } {

   set TheSrc $rInFo
   global [set TheSrc]

   upvar [set TheSrc] rI

# PRESET some fixed variables
#
#  wLb:  Option Labels
#  wID:  Widget ID's
#  aID:  Answer Array element ID's
#  iV :  The selected PMEIV level
#  BeG:  The next PMEIV level

   set wLb [list PROJECT MISSION EXPERIMENT INSTRUMENT VIRTUAL]
   set wID [list project mission exper inst vinst]
   set aID [list P M E I V]

   set iV [lsearch $aID $Src]
   set BeG [expr $iV + 1]

# THIS is the current setting

   set Old $rI($bN,$Src)
   set mF [list [lindex $rI($bN,mF) 0]]

# PROCESS the new selection.  If the setting didn't change then we don't
#  need to do anything more

   set tW  $W.[lindex $wID $iV] 
   if [winfo exists $tW] { 
      GUIoptsProcess $tW rI($bN,$Src) PRI $Index
      $tW configure -fg #000000
      $tW configure -activeforeground #000000
   }
   if [string match $Old $rI($bN,$Src)] { return }

# GENERALLY changing an option should cause changes everywhere below it and
#   all options below the selected on should be cleared and reset.  However 
#   in some cases this isn't so and options exist to allow the user to freeze 
#   all options except the one being accessed.  Freezing works so long as 
#   what's set in the next dependent option is one of the selections in the 
#   changed options option list.

   if $rI($bN,fWV) {
      if { $iV != 4 } {
         set oC DBudfLineage
         for { set I 0 } { $I <= $iV } { incr I } {
	    lappend oC $rI($bN,[lindex $aID $I])
	 }
	 set oPC "set nOps \[$oC\]"
	 eval $oPC
	 set fOK [lsearch -exact $nOps $rI($bN,[lindex $aID $BeG])]
      } else { set fOK 1 }

      if { $fOK < 0 }  {
         set rI($bN,fWV) 0
         if [winfo exists $rI($bN,fW)] { 
	    GUIchgConf $rI($bN,fW) THAW 
	 }
      }
   }

# IF options are frozen then we are done here

   if $rI($bN,fWV) { return }

   set dW [split $rI($bN,dW) "|"]
   set cW [split $rI($bN,cW) "|"]

# IF the options arn't frozen clear all options in the chain below the one 
#   just selected.  This will include all of the options in the Data Source
#   and Collapse GUI's should they be active.  
#
# REMEMBER to enable any options which can be disabled in case they are in
#   that state. 

   GUclearPMEIV $W $rInFo $bN $BeG 
   set cL [llength $dW]
   for { set I 0 } { $I < $cL } { incr I } {
      set tD [lindex $dW $I]
      set tC [lindex $cW $I]
      set sN $I
      if [winfo exists $tD] { GUclearDataSrc $tD $rInFo $bN $sN 0 }
      if [winfo exists $tC] { GUclearCollapse $tC $rInFo $bN $sN 0 disabled }
   }

#  Fill the options in the next higher menu.  IF PMEIV are totally defined
#    then the next menu options will be the source options in the Data Src
#    GUI.  Don't fill these in.  Let GUpidfOpts do that the first time it
#    is clicked on.

   set I 0
   set UdF ""
   set SuM 1
   while { ($SuM > 0) && ($I < 5) } { 
      set V $rI($bN,[lindex $aID $I])
      set SuM [expr $SuM * [string length $V]]
      lappend UdF $V
      incr I
   }

   if { ($SuM == 0) } {
      set pOp [DBudfLineage $rI($bN,P) $rI($bN,M) $rI($bN,E) $rI($bN,I)]
      set Nxt [lindex $aID $BeG]
      set We $W.[lindex $wID $BeG] 
      GUImenuFill $We $pOp "GUudfOpts $W $rInFo $bN $Nxt " NEW 0 $mF
      if { [llength $pOp] == 1 } { GUudfOpts $W $rInFo $bN $Nxt 0 }
   } 
}
