# THIS procedure will initialize the variables in a udf definition
#   If Type is EMPTY this is a full initialization otherwise it is an
#   initialization only of the variable has no definition.

package provide GUIUtils 1.0

proc GUudfInits { Src rInFo iD sID Type } {

   if ![string match OPS $Src] {
      set TheSrc $rInFo
      global [set TheSrc ]
      upvar [set TheSrc] rI
   } else { upvar $rInFo rI }

   set iX $iD.s$sID

   if [string match EMPTY $Type] {
      switch -exact -- $Src {
         PMEIV {
            set rI($iD,P) ""
            set rI($iD,M) ""
            set rI($iD,E) ""
            set rI($iD,I) ""
            set rI($iD,V) ""
            set rI($iD,dW) NULL
            set rI($iD,cW) NULL
            set rI($iD,fW) NULL
            set rI($iD,fWV) 0
         }
         DATA {
            set rI($iX,srcP) ""
            set rI($iX,srcA) ""
            set rI($iX,scr)   0
            set rI($iX,extra) 0
            set rI($iX,meaP) ""
            set rI($iX,meaA) ""
            set rI($iX,col)  ""
            set rI($iX,munP) ""
            set rI($iX,munA) ""
            set rI($iX,iunP) ""
            set rI($iX,iunA) ""
            set rI($iX,iun2P) ""
            set rI($iX,iun2A) ""
	    set rI($iX,SenType) Z
	    set rI($iX,iuFlg)  -1
         }
         COLLAPSE {
            set rI($iX,cMetP)  ""
            set rI($iX,cMetA)  ""
            set rI($iX,cBeg)   ""
            set rI($iX,cEnd)   ""
            set rI($iX,cBins)  ""
            set rI($iX,cScaP)  ""
            set rI($iX,cScaA)  ""
            set rI($iX,cLimP)  ""
            set rI($iX,cLimA)  ""
         }
      }
   } else {
      switch -exact -- $Src {
         PMEIV {
	    if ![info exists rI($iD,P)]       { set rI($iD,P)   ""    }
	    if ![info exists rI($iD,M)]       { set rI($iD,M)   ""    }
	    if ![info exists rI($iD,E)]       { set rI($iD,E)   ""    }
	    if ![info exists rI($iD,I)]       { set rI($iD,I)   ""    }
	    if ![info exists rI($iD,V)]       { set rI($iD,V)   ""    }
	    if ![info exists rI($iD,dW)]      { set rI($iD,dW)  NULL  }
	    if ![info exists rI($iD,cW)]      { set rI($iD,cW)  NULL  }
	    if ![info exists rI($iD,fW)]      { set rI($iD,fW)  NULL  }
	    if ![info exists rI($iD,fWV)]     { set rI($iD,fWV)  0    }
         }
         DATA {
	    if ![info exists rI($iX,srcP)]    { set rI($iX,srcP) ""   }
	    if ![info exists rI($iX,srcA)]    { set rI($iX,srcA) ""   }
	    if ![info exists rI($iX,scr)]     { set rI($iX,scr)   0   }
	    if ![info exists rI($iX,extra)]   { set rI($iX,extra) 0   }
	    if ![info exists rI($iX,meaP)]    { set rI($iX,meaP) ""   }
	    if ![info exists rI($iX,meaA)]    { set rI($iX,meaA) ""   }
	    if ![info exists rI($iX,col)]     { set rI($iX,col)  ""   }
	    if ![info exists rI($iX,munP)]    { set rI($iX,munP) ""   }
	    if ![info exists rI($iX,munA)]    { set rI($iX,munA) ""   }
	    if ![info exists rI($iX,iunP)]    { set rI($iX,iunP) ""   }
	    if ![info exists rI($iX,iunA)]    { set rI($iX,iunA) ""   }
	    if ![info exists rI($iX,iun2P)]   { set rI($iX,iun2P) ""  }
	    if ![info exists rI($iX,iun2A)]   { set rI($iX,iun2A) ""  }
	    if ![info exists rI($iX,SenType)] { set rI($iX,SenType) Z }
	    if ![info exists rI($iX,iuFlg)]   { set rI($iX,iuFlg)  -1 }
         }
         COLLAPSE {
	    if ![info exists rI($iX,cMetP)] { set rI($iX,cMetP)  "" }
	    if ![info exists rI($iX,cMetA)] { set rI($iX,cMetA)  "" }
	    if ![info exists rI($iX,cBeg)]  { set rI($iX,cBeg)   "" }
	    if ![info exists rI($iX,cEnd)]  { set rI($iX,cEnd)   "" }
	    if ![info exists rI($iX,cBins)] { set rI($iX,cBins)  "" }
	    if ![info exists rI($iX,cScaP)] { set rI($iX,cScaP)  "" }
	    if ![info exists rI($iX,cScaA)] { set rI($iX,cScaA)  "" }
	    if ![info exists rI($iX,cLimP)] { set rI($iX,cLimP)  "" }
	    if ![info exists rI($iX,cLimA)] { set rI($iX,cLimA)  "" }
         }
         OPS {
            if ![info exists rI(0)] { set rI(0) R    }
	    if ![info exists rI(1)] { set rI(1) V    }
	    if ![info exists rI(2)] { set rI(2) 5    }
	    if ![info exists rI(3)] { set rI(3) 0    }
	    if ![info exists rI(4)] { set rI(4) 0    }
	    if ![info exists rI(5)] { set rI(5) NO   }
	    if ![info exists rI(6)] { set rI(6) NO   }
	 }
      }
   }
}
