# THIS procedure will output a list of all of menu options needed to define
#    a UDF measurement source.
#
#  Ops Array
#

#    0 : Label position B(ottom) T(op) R(ight) L(eft) N(one)
#    1 : UNUSED:  THIS MENU HAS NO HORIZONTAL OUTPUT OPTION!
#    2 : The size of the response option widgets
#    3 : Prefix preappend to answer index as $oPs(3),xxx
#    4 : Sensor definition number used in answer as $oPs(3).s$oPs(4),xxx
#    5 : Whether or not to put up a top level label over the options
#    6 : Define 2 index arrays

package provide GUIUtils 1.0

proc GUudfDataSrc { W rInFo Ops { FonT "" } } {

   set TheSrc $rInFo
   global [set TheSrc ]
                                                                                
   upvar [set TheSrc] rI
   upvar $Ops wO

# SET up default options for those not established.
 
   GUudfInits OPS wO NULL 0 DEFINED

# IF this is one of multiple data definitions attached to a single source
#   then set the measurement number according to the given window definitions

   set bN $wO(3);
   set sV $wO(4);
   set sN $bN.s$sV

# If it hasn't already been initialized, initialize the sensor list.

   if [info exists rI($bN,SenL] { set rI($bN,SenL) [list 1] }

# STORE the font info if none exists

   if ![info exists rI($bN,mF)] { 
      set rI($bN,mF) $FonT 
   } else { set FonT $rI($bN,mF) }

# Break out all of the font bits

   set nF [llength $FonT]
   set mF [lindex $FonT 0]
   if { $nF > 1 } { set lF [lindex $FonT 1] } else { set lF $mF }
   if { $nF > 2 } { set lCol [lindex $FonT 2] } else { set lCol #FF0000 }

# IF the window doesn't exist assume that this is to be a top level window.
#   Otherwise it is a frame into which we will embed the buttons.

   if ![winfo exists $W] { toplevel $W }

# INITIALIZE the option answers.  Those appended with a P are the primary
#   responses and the A are the alternate responses.  Don't initialize
#   anything which already exists!  The caller may have preset some options
#   especially if they are being read in from a saved set of answers.

   GUudfInits DATA $rInFo $bN $sV DEFINED

# SET up the positioning parameters based on where and if a label is being 
#   output in conjunction with the option

   switch -exact -- $wO(0) {
      N  {  set lR 0 ; set bR 0 ; set lC 0 ; set bC 0
            set lP w ; set dR 1 ; set sP 1
         }
      L  {  set lR 0 ; set bR 0 ; set lC 0 ; set bC 1
            set lP w ; set dR 1 ; set sP 1
         }
      R  {  set lR 0 ; set bR 0 ; set lC 1 ; set bC 0
            set lP w ; set dR 1 ; set sP 1
         }
      T  {  set lR 0 ; set bR 1 ; set lC 0 ; set bC 0
            set lP c ; set dR 2 ; set sP 4
         }
      B  {  set lR 1 ; set bR 0 ; set lC 0 ; set bC 0
            set lP c ; set dR 2 ; set sP 4
         }
      default  {  set lR 0 ; set bR 0 ; set lC 0 ; set bC 0
            set lP w ; set dR 1 ; set sP 1
         }
   }

# OUTPUT a header label if we are supposed to.  Make it red and bold

   if [string match YES $wO(5)] {
      set LaB "MEASUREMENT DEFINITION"
      GUILabel $W.ltop $LaB c grid|$lR|0|news||5||5 0 -1 $lCol $lF
      incr lR ; incr bR
   }

# STICK the whole GUI into a single frame of the users choice.  There are
#   two builds depending on whether we are using labels or not

   set uOps ""

# THE source option has a Pre command which sets up the options prior to
#   their listing.

   set LaB "MEASUREMENT GROUP"
   GUIbuttonMenu $W.src "" grid|$bR|$bC|news||4 $uOps \
     "GUpidfOpts $W $rInFo $bN $sN src " 6 -1 \
     "GUpidfPreCmd $W $rInFo $bN $sV" left "" $mF

   if [string match N $wO(0)] { 
      $W.src configure -text $LaB -fg #0000FF -activeforeground #0000FF
   } else { GUILabel $W.lsrc $LaB $lP grid|$lR|$lC|news||$sP 3 20 #000000 }
   incr lR $dR ; incr bR $dR

   set LaB "BASE MEASUREMENT"
   GUIbuttonMenu $W.mea "" grid|$bR|$bC|news||3 $uOps  \
      "GUpidfOpts $W $rInFo $bN $sN mea " 6 -1 "" left "" $mF

   if [string match N $wO(0)] { 
      $W.mea configure -text $LaB -fg #0000FF -activeforeground #0000FF
   } else { GUILabel $W.lmea $LaB $lP grid|$lR|$lC|news||$sP 3 20 #000000 }

   set cN [expr $bC + 3]
   set rI($sN,col) "COL #"

   set V $rInFo ; append V ($sN,col)
   GUIboxEntry $W.col grid|$bR|$cN|news 6 $V "" $mF

   GUIstateSet $W.col REPLY disabled
   $W.col configure -fg #0000FF 
   incr lR $dR ; incr bR $dR

   if ![string match N $wO(0)] { 
      set LaB "RETURN VALUES"
      GUILabel $W.lscr $LaB $lP grid|$lR|$lC|news||$sP 3 20 #000000
   }

   set eOps [list "No Extra Sensors" "All In Group" "All Defined"]
   set V $rInFo ; append V ($sN,scr)
   GUIbuttonMenu $W.scr "No Extra Sensors" grid|$bR|$bC|news||2 $eOps  \
       "GUIoptsProcess $W.scr $V ALT " 6 0 "" "" "" $mF

   set cN [expr $bC + 2]
   set sOps [list "Return Sensor|0"]
   set V $rInFo ; append V ($sN,extra)
   GUIbuttonMenu $W.extra "Return Sensor" grid|$bR|$cN|news||2 $sOps  \
       "GUIoptsProcess $W.extra $V ALT " 6 0 "" "" "" $mF

   incr lR $dR ; incr bR $dR

   set LaB "MEASUREMENT UNIT"
   GUIbuttonMenu $W.mun "" grid|$bR|$bC|news||4 $uOps  \
      "GUpidfOpts $W $rInFo $bN $sN mun " 6 $wO(2) "" left  "" $mF

   if [string match N $wO(0)] { 
      $W.mun configure -text $LaB -fg #0000FF -activeforeground #0000FF
   } else { GUILabel $W.lmun $LaB $lP grid|$lR|$lC|news||$sP 3 20 #000000 }
   incr lR $dR ; incr bR $dR

   if [string match YES $rI($bN,TwoArray)] { 
      set LaB "ARRAY INDEX UNIT (1)"
   } else { set LaB "ARRAY INDEX UNIT" }

   GUIbuttonMenu $W.iun "" grid|$bR|$bC|news||4 $uOps \
      "GUpidfOpts $W $rInFo $bN $sN iun " 6 $wO(2) "" left "" $mF

   if [string match N $wO(0)] { 
      $W.iun configure -text $LaB -fg #0000FF -activeforeground #0000FF
   } else { GUILabel $W.liun $LaB $lP grid|$lR|$lC|news||$sP 3 20 #000000 }
   incr lR $dR ; incr bR $dR

# ADD the second ARRAY INDEX option is that was requested

   if [string match YES $rI($bN,TwoArray)] { 
      set LaB "ARRAY INDEX UNIT (2)"
      GUIbuttonMenu $W.iun2 "" grid|$bR|$bC|news||4 $uOps \
         "GUpidfOpts $W $rInFo $bN $sN iun2 " 6 $wO(2) "" left "" $mF

      if [string match N $wO(0)] { 
         $W.iun2 configure -text $LaB -fg #0000FF -activeforeground #0000FF
      } else { GUILabel $W.liun2 $LaB $lP grid|$lR|$lC|news||$sP 3 20 #000000 }
   }

# THIS binding removes the COLUMN # label from the COLUMN entry box if its 
#   there.  After erasing the label it switches the text color to black

   bind $W.col <Any-Key> { 
      if [string match COL* [%W get]] {
         %W delete 0 end 
         %W configure -fg #000000  
      }
   }
}
