# THIS procedure will output a collapse menu which can be used to define
#   how a 2D UDF source can be reduced to a 1D data set
#
#  Ops Array
#
#    0 : Label position B(ottom) T(op) R(ight) L(eft) N(one)
#    1 : Display menu V(ertically) or H(orizontally)
#    2 : UNUSED
#    3 : Prefix preappend to answer index as $oPs(3),xxx

package provide GUIUtils 1.0

proc GUudfCollapse { W rInFo Opts { FonT "" } } {

   set TheSrc $rInFo
   global [set TheSrc ]
                                                                                
   upvar [set TheSrc] rI
   upvar $Opts wO
                                                                                
# SET up default options for those not established.
 
   GUudfInits OPS wO NULL 0 DEFINED

# IF this is one of multiple data definitions attached to a single source
#   then set the measurement number according to the given window definitions

   set bN $wO(3)
   set sV $wO(4)
   set sN $bN.s$sV

# STORE the font info if none exists

   if ![info exists rI($bN,mF)] { 
      set rI($bN,mF) $FonT 
   } else { set FonT $rI($bN,mF) }

# Break out all of the font bits

   set nF [llength $FonT]
   set mF [lindex $FonT 0]
   if { $nF > 1 } { set lF [lindex $FonT 1] } else { set lF $mF }
   if { $nF > 2 } { set lCol [lindex $FonT 2] } else { set lCol #FF0000 }

# IF the window doesn't exist assume that this is to be a top level window.
#   Otherwise it is a frame into which we will embed the buttons.

   if ![winfo exists $W] { toplevel $W }

# INITIALIZE the option answers.  Those appended with a P are the primary
#   responses and the A are the alternate responses.  Don't initialize
#   anything which already exists!  The caller may have preset some options.

   GUudfInits COLLAPSE $rInFo $bN $sV DEFINED

# SET up the positioning parameters based on where and if a label is being 
#   output in conjunction with the option

   set dR 0
   set dC 0
   switch -exact -- $wO(0) {
      N  {  set lR 0 ; set bR 0
            set lC 0 ; set bC 0
            set lP w 
            if { $wO(1) == "V" } {
               set dR 1 ; set tLs 1
            } else { set dC 1 ; set tLs 5 }
  
         }
      L  {  set lR 0 ; set bR 0
            set lC 0 ; set bC 1
            set lP w 
            if { $wO(1) == "V" } { set dR 1 } else { set dC 2 }
         }
      R  {  set lR 0 ; set bR 0
            set lC 1 ; set bC 0
            set lP w 
            if { $wO(1) == "V" } { set dR 1 } else { set dC 2 }
         }
      T  {  set lR 0 ; set bR 1
            set lC 0 ; set bC 0
            set lP c 
            if { $wO(1) == "V" } { set dR 2 } else { set dC 1 }
         }
      B  {  set lR 1 ; set bR 0
            set lC 0 ; set bC 0
            set lP c 
            if { $wO(1) == "V" } { set dR 2 } else { set dC 1 }
         }
   }

# OUTPUT a header label if we are supposed to.  Make it red and bold
                                                                                
   if [string match YES $wO(5)] {
      set LaB "COLLAPSE"
      GUILabel $W.ltop $LaB c grid|$lR|0|news||5||5 0 -1 $lCol $lF
      incr lR ; incr bR 
   }

# STICK the whole thing into a single frame of the users choice.  There are
#   two builds depending on whether we are using labels or not

   set uOps ""

   set ftOps [list SUM|0 INTEGRATE|1]
   set LaB "METHOD"
   GUIbuttonMenu $W.met "" grid|$bR|$bC|news $ftOps  \
       "GUcollapseOpt $W.met $rInFo $sN cMet " 0 -1 "" "" "" $mF
 
   if [string match N $wO(0)] { 
      $W.met configure -text $LaB -fg #0000FF -activeforeground #0000FF
   } else { GUILabel $W.lmet $LaB $lP grid|$lR|$lC|news 3 10 #000000 $mF }
  
   incr lR $dR ; incr bR $dR ; incr lC $dC ; incr bC $dC

   set LaB "BEG AT"
   GUIboxEntry $W.beg grid|$bR|$bC|news 10 NULLa$sN "" $mF

   if [string match N $wO(0)] { 
      $W.beg insert end $LaB
      $W.beg configure -fg #0000FF 
   } else { GUILabel $W.lbeg $LaB $lP grid|$lR|$lC|news 3 10 #000000 $mF }
   bind $W.beg <KeyPress> "GUcollapseOpt %W $rInFo $sN cBeg BEG*"
   bind $W.beg <KeyRelease> "GUcollapseOpt %W $rInFo $sN cBeg BEG*"
   incr lR $dR ; incr bR $dR ; incr lC $dC ; incr bC $dC
 
   set LaB "END AT"
   GUIboxEntry $W.end grid|$bR|$bC|news 10 NULLb$sN "" $mF

   if [string match N $wO(0)] { 
      $W.end insert end $LaB
      $W.end configure -fg #0000FF 
   } else { GUILabel $W.lend $LaB $lP grid|$lR|$lC|news 3 10 #000000 $mF }
   bind $W.end <KeyPress> "GUcollapseOpt %W $rInFo $sN cEnd END*"
   bind $W.end <KeyRelease> "GUcollapseOpt %W $rInFo $sN cEnd END*"
   incr lR $dR ; incr bR $dR ; incr lC $dC ; incr bC $dC

   set LaB "BINS"
   GUIboxEntry $W.bins grid|$bR|$bC|news 10 NULLc$sN  "" $mF
   if [string match N $wO(0)] { 
      $W.bins configure -fg #0000FF 
      $W.bins insert end $LaB
   } else { GUILabel $W.lbins $LaB $lP grid|$lR|$lC|news 3 10 #000000 $mF }
   bind $W.bins <KeyPress> "GUcollapseOpt %W $rInFo $sN cBins BINS"
   bind $W.bins <KeyRelease> "GUcollapseOpt %W $rInFo $sN cBins BINS"
   incr lR $dR ; incr bR $dR ; incr lC $dC ; incr bC $dC

   set ftOps [list ENDS|0 CENTERS|1]
   set LaB "LIMITS"
   GUIbuttonMenu $W.lim "" grid|$bR|$bC|news $ftOps  \
       "GUcollapseOpt $W.lim $rInFo $sN cLim " 0 -1 "" "" "" $mF

   if [string match N $wO(0)] { 
      $W.lim configure -text $LaB -fg #0000FF -activeforeground #0000FF
   } else { GUILabel $W.llim $LaB $lP grid|$lR|$lC|news 3 10 #000000 $rmF }
   incr lR $dR ; incr bR $dR ; incr lC $dC ; incr bC $dC

   set ftOps [list LINEAR|0 LOG|1]
   set LaB "SCALING"
   GUIbuttonMenu $W.sca "" grid|$bR|$bC|news $ftOps  \
       "GUcollapseOpt $W.sca $rInFo $sN cSca " 0 -1 "" "" "" $mF

   if [string match N $wO(0)] { 
      $W.sca configure -text $LaB -fg #0000FF -activeforeground #0000FF
   } else { GUILabel $W.lsca $LaB $lP grid|$lR|$lC|news 3 10 #000000 $rmF }

   GUclearCollapse $W $rInFo $sN 0 disabled
}
