# THIS procedure saves a set of PMEIV, Data Source, and Collapse menu

package provide GUIUtils 1.0

proc GUsaveUDF { fd iD mANS { aS "" } } {
   global env

   upvar $mANS A

   if { [string length $aS] == 0 } { set aS $iD }

# THE UDF source variables that need to be saved

   set usV [list P M E I V]

# THE measurement variables that need to be saved

   set mV [list iuFlg SenType srcP meaP col scr extra munP \
                iunP iun2P srcA meaA munA iunA iun2A ]
   set nM [llength $mV]

# THE collapse variables that need to be saved

   set cV [list cMetP cMetA cBeg cEnd cBins cLimP cLimA cScaP cScaA ] 
   set nC [llength $cV]

# SOME top level information 

   if [info exists A($iD,Title)] { puts $fd $aS,Title|$A($iD,Title) }
   if [info exists A($iD,AddCol)] { puts $fd $aS,AddCol|$A($iD,AddCol) }
   if [info exists A($iD,WithDel)] { puts $fd $aS,WithDel|$A($iD,WithDel) }
   if [info exists A($iD,WithAdd)] { puts $fd $aS,WithAdd|$A($iD,WithAdd) }
   if [info exists A($iD,DsplFmt)] { puts $fd $aS,DsplFmt|$A($iD,DsplFmt) }

# SAVE the font setup 

   if [info exists A($iD,mF)] { puts $fd "$aS,mF|$A($iD,mF)" }

# SAVE the freeze value

   if [info exists A($iD,fWV)] { puts $fd "$aS,fWV|$A($iD,fWV)" }

# SAVE the UDF source information

   for { set I 0 } { $I < 5 } { incr I } {
      set iX $iD,[lindex $usV $I]
      set iY $aS,[lindex $usV $I]
      if [info exists A($iX)] { puts $fd "$iY|$A($iX)" }
   }

# SAVE the measurement information and any corresponding collapse information

   set NewL ""
   set nS [llength $A($iD,SenL)]
   set cS 0
   for { set J 0 } { $J < $nS } { incr J } {
      set sID [lindex $A($iD,SenL) $J]
      if { $sID <= 0 } { continue }
      lappend NewL 1

      for { set I 0 } { $I < $nM } { incr I } {
         set mI $iD.s$cS,[lindex $mV $I]
         set mJ $aS.s$cS,[lindex $mV $I]
         if [info exists A($mI)] { puts $fd "$mJ|$A($mI)" }
      }

      for { set I 0 } { $I < $nC } { incr I } {
         set mI $iD.s$cS,[lindex $cV $I]
         set mJ $aS.s$cS,[lindex $mV $I]
         if [info exists A($mI)] { puts $fd "$mJ|$A($mI)" }
      }
      incr cS
   }

   if { [llength $NewL] > 0 } {
      set iY $aS,SenL
      puts $fd "$iY|$NewL"
   }
}
