# THIS procedure will pre-fill in the data souces in the measurement menu 
#   cascade of options.  This is used since GUudfPMEIV does not fill in
#   these options.

package provide GUIUtils 1.0

proc GUpidfPreCmd { W rInFo bN sV } {

   set TheSrc $rInFo
   global [set TheSrc ]
                                                                                
   upvar [set TheSrc] rI


# FORM the source array ID

   if { $sV == "E" } {
      set sN $bN
   } else { set sN $bN.s$sV }

   set mF [list [lindex $rI($bN,mF) 0]]

# THIS is the PMEIV list for ReadPIDF taken presumably from the input 
#   to GUudfPMEIV but the caller may have preset the answers
                                                                                
   set UdF [list $rI($bN,P) $rI($bN,M) $rI($bN,E) $rI($bN,I) $rI($bN,V)]

# IF we are looking for the measurement source then we need to fill it
#   even if already filled.
 
   set dW $W.src
   set pOp [GUpidfLists $UdF DataSource DUMMY]
   GUImenuFill $dW $pOp "GUpidfOpts $W $rInFo $bN $sN src " NEW 0 $mF
   if { [llength $pOp] == 1 } {
        GUpidfOpts $W $rInFo $bN $sN src 0
   }
}
