# THIS procedure will return option lists built from a PIDF file

package provide GUIUtils 1.0

proc GUpidfOpts { W rInFo bN sN sID Index } {
   global env Pidf0 GUIoptAlts

   set TheSrc $rInFo
   global [set TheSrc ]
                                                                                
   upvar [set TheSrc] rI

# THIS is the PMEIV list for ReadPIDF taken presumably from the input 
#   to GUudfPMEIV but the caller may have preset the answers
                                                                                
   set UdF [list $rI($bN,P) $rI($bN,M) $rI($bN,E) $rI($bN,I) $rI($bN,V)]

# WE need the corresponding collapse window definition for this data 
#    definition window.

    set P  [lsearch -exact [split $rI($bN,dW) "|"] $W]
    set cW [lindex [split $rI($bN,cW) "|"] $P]
    set mF [list [lindex $rI($bN,mF) 0]]

# THIS is the current setting

   set Old $rI($sN,${sID}A)

# PROCESS the new selection.  Get both the primary and alternate settings.
#   If the new setting is the same as the old setting they there is nothing
#   that needs to be updated and we can leave.

   GUIoptsProcess $W.$sID rI($sN,${sID}P) PRI $Index
   GUIoptsProcess $W.$sID rI($sN,${sID}A) ALT $Index
   $W.$sID configure -fg #000000
   $W.$sID configure -activeforeground #000000
   if [string match $Old $rI($sN,${sID}A)] { return }

# CHANGING an option should effect all following options and they need to be
#   reset and reselected.  However if the user has chosen to freeze the 
#   the already selected options they are left as is and we hope that the
#   user knows what he or she is doing.  So if freeze is set we are
#   out of here. 

   if $rI($bN,fWV) { return }

# SO no freeze.  Based on what option was selected we need to update the 
#   next option or options in its chain.  Before doing that however clear
#   out all the dependent options  
#
# A few NOTES:
#
#  1.  IF the source data is either AUXILLARY or MODE there is no associated 
#      property data.  So disable these options.  IF this a measurement from
#      the PIDF SENSOR area then we have to wait until the measurement is
#      selected to see if is an ancillary measurement and then do the 
#      disabling.
#
#  2.  The Pitch Angle option is disabled either if there is no pitch angle
#      section in the PIDF OR if the selected sensor pitch angle available
#      flag has been set to N.
#
#  3.  The unit options loaded here are those belonging to the base sensor.
#      this changes if one of the data products is selected later
#
#  4.  The array index units are only loaded if the sensor definition
#      indicates that this exists.

   set Cmd "GUpidfOpts $W $rInFo $bN $sN"
   if [string match src $sID] {
      GUclearDataSrc $W $rInFo $bN $sN 1
      if [winfo exists $cW] { GUclearCollapse $cW $rInFo $sN 0 disabled }
                                                                                
      switch -exact -- $rI($sN,srcA) {
         A0 {
            set pOp [GUpidfLists $UdF Ancillary DUMMY]
            GUImenuFill $W.mea $pOp "$Cmd mea " NEW 0 $mF
         }
         A1 {
            set pOp [GUpidfLists $UdF Modes DUMMY]
            GUImenuFill $W.mea $pOp "$Cmd mea " NEW 0 $mF
            GUIstateSet $W.iun MBUTTON disabled 
	    if [string match YES $rI($bN,TwoArray)] {
               GUIstateSet $W.iun2 MBUTTON disabled 
            }
         }
         default {
            set Deps(0) $rI($sN,${sID}A) 
            set pOp [GUpidfLists $UdF Sensors Deps ]
            GUImenuFill $W.mea $pOp "$Cmd mea " NEW 0 $mF
         }
      }
      if { [llength $pOp] == 1 } { eval $Cmd mea 0 }
   } elseif [string match mea $sID] {
      GUclearDataSrc $W $rInFo $bN $sN 3

      set Deps(0) $rI($sN,srcA) 
      set Deps(1) $rI($sN,meaA) 
      set pOp [GUpidfLists $UdF Munits Deps ]
      GUImenuFill $W.mun $pOp "$Cmd mun " NEW 0 $mF
      if { [llength $pOp] == 1 } { eval $Cmd mun 0 }

      set rI($sN,iuFlg) -1
      if { [string index $Deps(0) 0] != "A" } {
         set pOp [GUpidfLists $UdF DataProducts DUMMY]
         set pAF [lindex $Pidf0(SenPa) $Deps(1)]
         set rI($sN,iuFlg) [lindex $Pidf0(SenScanBlk) $Deps(1)]
         set rI($sN,extra) 0
         set sOps [list "Return Sensor|0"]
         if { [lsearch $pOp dq] >= 0 } { lappend sOps "Return dQual|1" }
         if { [lsearch $pOp sa] >= 0 } { lappend sOps "Return Phase|2" }
         if { ([lsearch $pOp pa] >= 0) && [string match Y $pAF] } { 
            lappend sOps "Return PitchAngle|3" 
         }
         set V $rInFo ; append V ($sN,extra)
         GUImenuFill $W.extra $sOps "GUIoptsProcess $W.extra $V ALT " NEW 0 $mF
      } elseif { [string index $Deps(0) 1] == 0 } { 
         set I 0
         while { ($I < $Pidf0(NSens)) && ($rI($sN,iuFlg) < 0) } {
            if { [lindex $Pidf0(SenSrc) $Deps(1)] == "V" } { 
               set rI($sN,iuFlg) [lindex $Pidf0(SenScanBlk) $Deps(1)]
            }
         }
      }  

      set rI($sN,SenType) $Pidf0(SenType)
      if { $Pidf0(SenType) != "M" } {
         GUIstateSet $W.col REPLY disabled
         set rI($sN,col) "Col #"
      } else { 
         set rI($sN,col) 0
         GUIstateSet $W.col REPLY normal 
      }

      set tW  $W.iun
      set tW2 $W.iun2
      if { $rI($sN,iuFlg) < 0 } {
         GUIstateSet $tW  MBUTTON disabled 
	 if [string match YES $rI($bN,TwoArray)] {
            GUIstateSet $tW2 MBUTTON disabled 
         }
         if [winfo exists $cW] { GUclearCollapse $cW $rInFo $sN 0 disabled }
      } else { 
         GUIstateSet $tW MBUTTON normal 
         if [winfo exists $cW] { GUclearCollapse $cW $rInFo $sN 0 normal }
         set Deps(0) $rI($sN,iuFlg)
         set pOp [GUpidfLists $UdF Iunits Deps ]
         GUImenuFill $tW $pOp "$Cmd iun " NEW 0 $mF
         if { [llength $pOp] == 1 } { eval $Cmd iun 0 }

	 if [string match YES $rI($bN,TwoArray)] {
            GUIstateSet $tW2 MBUTTON normal 
            GUImenuFill $tW2 $pOp "$Cmd iun2 " NEW 0 $mF
            if { [llength $pOp] == 1 } { eval $Cmd iun2 0 }
         }
      }
   }
}
