# THIS procedure will return option lists built from a PIDF file

package provide GUIUtils 1.0

proc GUpidfLists { PmeiV Option Deps } {
   global env Pidf0 

   upvar $Deps dP

# READ in the PIDF from which info is needed.  This will only occur if its
#   not the last accessed PIDF.

   set KeY [GetDataKey $PmeiV]
   if { [ReadPIDF $KeY] < 0 } { return "" }

# SEVERAL COMMENTS:
#
#  1. DataSource is the combination of the defined PIDF data groups and the 
#     data sources which are not represented in the data groups.  The data
#     sources are tacked onto the end of the group listing.  Omitted are 
#     the sensor source which are fully covered in the groups and the quality
#     which can be selected when the sensor is selected.  Data sources have
#     an ALTERNATE value beginning with A

   set oPs ""
   switch -exact -- $Option {
      DataProducts {
         set MasK [list 1 32 64]
         set wID [list dq pa sa]
         set Len  [llength $MasK]
         for { set I 0 } { $I < $Len } { incr I } {
            set OpSet [expr $Pidf0(DataMask) & [lindex $MasK $I]]
            if { $OpSet > 0 } { lappend oPs [lindex $wID $I] }
         }
      }

      DataSource {
         for { set I 0 } { $I < $Pidf0(NGroups) } { incr I } {
             lappend oPs [lindex $Pidf0(GrpName) $I]|$I
         }
         
         set MasK [list 4 2]
         set Grp  [list Ancillary Mode]
         set Len  [llength $MasK]
         for { set I 0 } { $I < $Len } { incr I } {
            set OpSet [expr $Pidf0(DataMask) & [lindex $MasK $I]]
            if { $OpSet > 0 } { lappend oPs "[lindex $Grp $I] Data|A$I" }
         }
      }
      Sensors {
         for { set I 0 } { $I < $Pidf0(NSens) } { incr I } {
            if { [lindex $Pidf0(SenGrpN) $I] == $dP(0) } {
                lappend oPs [lindex $Pidf0(SenName) $I]|$I
            }
         }
      }
      Modes {
         for { set I 0 } { $I < $Pidf0(NModes) } { incr I } {
            lappend oPs [lindex $Pidf0(ModeName) $I]|$I
         }
      }
      Ancillary {
         for { set I 0 } { $I < $Pidf0(NAncs) } { incr I } {
            lappend oPs [lindex $Pidf0(AncName) $I]|$I
         }
      }
      Phase {
         for { set I 0 } { $I < $Pidf0(NPhase) } { incr I } {
            lappend oPs [lindex $Pidf0(sAName) $I]|$I
         }
      }
      Pitch {
         for { set I 0 } { $I < $Pidf0(NPitch) } { incr I } {
            lappend oPs [lindex $Pidf0(pAName) $I]|$I
         }
      }
      Munits {
         switch -exact -- $dP(0) {
            A0 {
               set nUnits [lindex $Pidf0(AncNunits) $dP(1)]
               set Units [lindex $Pidf0(AncUnits) $dP(1)]
               for { set I 0 } { $I < $nUnits } { incr I } {
                  set uN [lindex $Units $I]
                  set NamE [lindex $Pidf0(UnitLDes) $uN]
                  set SyM  [lindex $Pidf0(UnitLab) $uN]
                  lappend oPs "$NamE ($SyM)|$uN"
               }
            }
            A1 {
               set nUnits [lindex $Pidf0(ModeNunits) $dP(1)]
               set Units [lindex $Pidf0(ModeUnits) $dP(1)]
               for { set I 0 } { $I < $nUnits } { incr I } {
                  set uN [lindex $Units $I]
                  set NamE [lindex $Pidf0(UnitLDes) $uN]
                  set SyM  [lindex $Pidf0(UnitLab) $uN]
                  lappend oPs "$NamE ($SyM)|$uN"
               }
            }
            default {
               set nUnits [lindex $Pidf0(SenNunits) $dP(1)]
               set Units [lindex $Pidf0(SenUnits) $dP(1)]
               for { set I 0 } { $I < $nUnits } { incr I } {
                  set uN [lindex $Units $I]
                  set NamE [lindex $Pidf0(UnitLDes) $uN]
                  set SyM  [lindex $Pidf0(UnitLab) $uN]
                  lappend oPs "$NamE ($SyM)|$uN"
               }
            }
         }
      }
      Iunits {
         set Units [lindex [lindex $Pidf0(Scan) $dP(0)] 1]
         set nU [llength $Units]
         for { set I 0 } { $I < $nU } { incr I } {
            set uN [lindex $Units $I]
            set NamE [lindex $Pidf0(UnitLDes) $uN]
            set SyM  [lindex $Pidf0(UnitLab) $uN]
            lappend oPs "$NamE ($SyM)|$uN"
         }
      }
      Punits {
         set nUnits [lindex $Pidf0(pANunits) 0]
         set Units [lindex $Pidf0(pAUnits) 0]
         for { set I 0 } { $I < $nUnits } { incr I } {
            set uN [lindex $Units $I]
            set NamE [lindex $Pidf0(UnitLDes) $uN]
            set SyM  [lindex $Pidf0(UnitLab) $uN]
            lappend oPs "$NamE ($SyM)|$uN"
         }
      }
      Sunits {
         set nUnits [lindex $Pidf0(sANunits) 0]
         set Units [lindex $Pidf0(sAUnits) 0]
         for { set I 0 } { $I < $nUnits } { incr I } {
            set uN [lindex $Units $I]
            set NamE [lindex $Pidf0(UnitLDes) $uN]
            set SyM  [lindex $Pidf0(UnitLab) $uN]
            lappend oPs "$NamE ($SyM)|$uN"
         }
      }
      Qunits {
         set nUnits [lindex $Pidf0(dQNunits) 0]
         set Units [lindex $Pidf0(dQUnits) 0]
         for { set I 0 } { $I < $nUnits } { incr I } {
            set uN [lindex $Units $I]
            set NamE [lindex $Pidf0(UnitLDes) $uN]
            set SyM  [lindex $Pidf0(UnitLab) $uN]
            lappend oPs "$NamE ($SyM)|$uN"
         }
      }
   }

   return $oPs
}
