# THIS procedure fills in a set of PMEIV, Data Source, and Collapse menu
#   options.  The routine is basically used when reading a set of saved
#   option values and recreating the GUI menu.

package provide GUIUtils 1.0

proc GUfillUdfSrc { W AnS bN } {

   set TheSrc $AnS
   global [set TheSrc ]

   upvar [set TheSrc] A

   set A(MenuFill) 1

   if [info exists A($bN,SenL)] { 
       set nS [llength $A($bN,SenL)]
   } else { set nS 0 }

   if ![info exists A($bN,Title)] { set A($bN,Title) "" }

   if ![info exists A($bN,AddCol)] { set A($bN,AddCol) NO }
   if ![info exists A($bN,WithDel)] { set A($bN,WithDel) NO }
   if ![info exists A($bN,WithAdd)] { set A($bN,WithAdd) YES }
   if ![info exists A($bN,DsplFmt)] { set A($bN,DsplFmt) OU }
   if ![info exists A($bN,TwoArray)] { set A($bN,TwoArray) NO }
   if ![info exists A($bN,mF)] { set A($bN,mF) "" }

   if ![info exists A($bN,Opened)] {
      set oP [list $A($bN,mF) $A($bN,WithDel) $A($bN,WithAdd) \
          $A($bN,DsplFmt) $A($bN,TwoArray)]
      GUudfSrc $W $A($bN,Title) $A($bN,AddCol) $bN $AnS rI 
   }

   GUfillPMEIV $W.mUDF $AnS $bN
   GUfillDataSrc $A($bN,dW) $AnS $bN
   if [string match YES $A($bN,AddCol)] {
      GUfillCollapse $A($bN,cW) $AnS $bN
   }

   for { set J 1 } { $J < $nS } { incr J } {
      set A($bN,SenL) [lreplace $A($bN,SenL) $J $J  0]
      GUaddSensor $W $bN $AnS
      set dW [lindex [split $A($bN,dW) "|"] $J]
      GUfillDataSrc $dW $AnS $bN
      if [string match YES $A($bN,AddCol)] {
         set cW [lindex [split $A($bN,cW) "|"] $J]
         GUfillCollapse $cW $AnS $bN
      }
   }

   set A(MenuFill) 0
}
