# THIS procedure fills in a Data Source menu 

package provide GUIUtils 1.0

proc GUfillDataSrc { dW AnS bN } {

   set TheSrc $AnS
   global [set TheSrc ]

   upvar [set TheSrc] A

# THIS is the UDF lineage

  set UdF [list $A($bN,P) $A($bN,M) $A($bN,E) $A($bN,I) $A($bN,V)]

# RE-ESTABLISH the measurement options

# Determine the corresponding collapse window and the measurement number

   set P  [lsearch -exact [split $A($bN,dW) "|"] $dW]
   set cW [lindex [split $A($bN,cW) "|"] $P]
   set sN $bN.s$P
   set mF [list [lindex $A($bN,mF) 0]]

# FILL the measurement options

   if [winfo exists $dW] {
#     set pC "GUpidfOpts $dW $AnS $bN $sN $P"

      set pC "GUpidfOpts $dW $AnS $bN $sN"

# GROUP option

      if { [string length $A($bN,V)] > 0 } {
         set Wp $dW.src
         set pOp [GUpidfLists $UdF DataSource DUMMY]
         set npC "$pC src "
         $Wp configure -fg #000000
         GUIchgConf $Wp $A($sN,srcP) ""
         GUImenuFill $Wp $pOp $npC NEW 0 $mF
      } else { return }

# MEASUREMENT definition.  This includes checking the measurement type and
#   if its matrix enabling the matrix column option.

      if { [string length $A($sN,srcP)] > 0 } {
         set Wp $dW.mea

         if [string match A0 $A($sN,srcA)] {
            set SrC Ancillary
         } elseif [string match A1 $A($sN,srcA)] {
            set SrC Modes
         } else { set SrC Sensors }

         set Deps(0) $A($sN,srcA)
         set pOp [GUpidfLists $UdF $SrC Deps ]
         set npC "$pC mea "
         $Wp configure -fg #000000
         GUIchgConf $Wp $A($sN,meaP)
         GUImenuFill $Wp $pOp $npC NEW 0 $mF

         if { [string match Sensors $SrC] } {
            if { $A($sN,SenType) == "M" } { 
	        GUIstateSet $Wp.col REPLY normal 
	    }
         }
      } else { return }

# MEASUREMENT UNITS.  This depends on what's been selected.  This is either
#   a direct measurement (sensor, ancillary, mode) or the spin angle pitch
#   angle or quality flag. Only sensor and ancillary units can have units 
#   associated the array indices.

      set Wp $dW.mun
      if { $A($sN,extra) == 0 } {
         if { [string length $A($sN,meaP)] > 0 } {
            set Deps(0) $A($sN,srcA)
            set Deps(1) $A($sN,meaA)
            set pOp [GUpidfLists $UdF Munits Deps]
            set npC "$pC mun "
            $Wp configure -fg #000000
            GUIchgConf $Wp $A($sN,munP)
            GUImenuFill $Wp $pOp $npC NEW 0 $mF
            if { $A($sN,iuFlg) >= 0 } {
               set Wp $dW.iun
               set Deps(0) $A($sN,iuFlg)
               set pOp [GUpidfLists $UdF Iunits Deps]
               set npC "$pC iun "
               $Wp configure -fg #000000
               GUIchgConf $Wp $A($sN,iunP)
               GUImenuFill $Wp $pOp $npC NEW 0 $mF
	       if [string match YES $A($bN,TwoArray)] {
                  set Wp $dW.iun2
                  set npC "$pC iun2 "
                  $Wp configure -fg #000000
                  GUIchgConf $Wp $A($sN,iun2P)
                  GUImenuFill $Wp $pOp $npC NEW 0 $mF
	       }
            }
         } else { return }
      } elseif { $A($sN,extra) == 1 } {
         set pOp [GUpidfLists $UdF Qunits DUMMY]
         $Wp configure -fg #000000
         GUIchgConf $Wp $A($sN,munP)
         GUImenuFill $Wp $pOp $pC NEW 0 $mF
      } elseif { $A($sN,extra) == 2 } {
         set pOp [GUpidfLists $UdF Sunits DUMMY]
         $Wp configure -fg #000000
         GUIchgConf $Wp $A($sN,munP)
         GUImenuFill $Wp $pOp $pC NEW 0 $mF
      } elseif { $A($sN,extra) == 3 } {
         set pOp [GUpidfLists $UdF Punits DUMMY]
         $Wp configure -fg #000000
         GUIchgConf $Wp $A($sN,munP)
         GUImenuFill $Wp $pOp $pC NEW 0 $mF
      }
   }

# SENSORS to process

   set Wp $dW.scr
   GUIchgConf $Wp [GUIoptsInfo $Wp OPTV $A($sN,scr) ALT PRI]
}
