# THIS procedure fills in a set of PMEIV, Data Source, and Collapse menu
#   options.  The routine is basically used when reading a set of saved
#   option values and recreating the GUI menu.

package provide GUIUtils 1.0

proc GUfillCollapse { cW AnS bN } {

   set TheSrc $AnS
   global [set TheSrc ]

   upvar [set TheSrc] A

   if [winfo exists $cW] {

      set P  [lsearch -exact [split $A($bN,cW) "|"] $cW]
      set S $bN.s$P

      GUclearCollapse $cW $AnS $S 0 normal

# RE-ESTABLISH the collapse options

      if [info exists A($S,cMetP)] { 
         if { [string length $A($S,cMetP)] == 0 } {
             $cW.met configure -fg #0000FF
         } else { $cW.met configure -fg #000000 }
         $cW.met configure -text $A($S,cMetP) 
      }
      if [info exists A($S,cScaP)] { 
         if { [string length $A($S,cScaP)] == 0 } {
             $cW.sca configure -fg #0000FF
         } else { $cW.sca configure -fg #000000 }
         $cW.sca configure -text $A($S,cScaP) 
      }
      if [info exists A($S,cLimP)] { 
         if { [string length $A($S,cLimP)] == 0 } {
             $cW.lim configure -fg #0000FF
         } else { $cW.lim configure -fg #000000 }
         $cW.lim configure -text $A($S,cLimP) 
      }

# FILL in the collapse entry boxes since they are not set directly to the
#   variables.

      if [info exists A($S,cBeg)] { 
         if [string match BEG* $A($S,cEnd)] {
             $cW.beg configure -fg #0000FF
         } else { $cW.beg configure -fg #000000 }
         $cW.beg delete 0 end
         $cW.beg insert end $A($S,cBeg) 
      }
      if [info exists A($S,cEnd)] { 
         if [string match END* $A($S,cEnd)] {
             $cW.end configure -fg #0000FF
         } else { $cW.end configure -fg #000000 }
         $cW.end delete 0 end
         $cW.end insert end $A($S,cEnd) 
      }
      if [info exists A($S,cBins)] { 
         if [string match BINS* $A($S,cBins)] {
             $cW.bins configure -fg #0000FF
         } else { $cW.bins configure -fg #000000 }
         $cW.bins delete 0 end
         $cW.bins insert end $A($S,cBins) 
      }
   }
}
