# THIS procedure will add a sensor definition to a menu put up via
#   GUudfSrc

package provide GUIUtils 1.0

proc GUaddSensor { W iD rInFo } {
 
# THIS is the definition of the filled in option array

   set TheSrc $rInFo
   global [set TheSrc ]
                                                                                
   upvar [set TheSrc] rI

# Break out all of the font

   set mF [lindex $rI($iD,mF) 0]

#  Look through the sensor list.  If there is a blank spot where a sensor
#    was deleted then add this sensor there otherwise stick it on the end
#    of the list.  The Row a sensor window goes into is its number + 2.

   set sL [llength $rI($iD,SenL)]
   set P -1
   for { set I 0 } { $I < $sL } { incr I } {
      if ![lindex $rI($iD,SenL) $I] { 
	 set P $I
	 set rI($iD,SenL) [lreplace $rI($iD,SenL) $I $I  1]
         break 
      }
   }
   if { $P < 0 } {
      set P $sL
      lappend rI($iD,SenL) 1
   }
   set R [expr $I + 2]; 

# Define the sensor windows
         
   set Wd $W.mMEA$P
   GUIFrame $Wd -1 grid|$R|0|news
   append rI($iD,dW) "|$Wd"

   if [string match YES $rI($iD,AddCol)] {
      set We $W.mCOL$P
      set Wf $W.mDel$P
      GUIFrame $We -1 grid|$R|1|news
      GUIFrame $Wf -1 grid|$R|2|news
      append rI($iD,cW) "|$We"
      set dW $Wf
   } else {
      set We $W.mDel$P
      GUIFrame $We -1 grid|$R|1|news
      append rI($iD,cW) "|NULL"
      set dW $We
   }

   GUIbuttonPush $dW.del "DELETE" pack|bottom|se \
       "GUdelSensor $W $iD $P $rInFo" 6 0 "" "" "" $mF

   set oP(0) N
   set oP(1) V
   set oP(2) -1
   set oP(3) $iD
   set oP(4) $P
   set oP(5) YES

   GUudfDataSrc $Wd $rInFo oP
   if [string match YES $rI($iD,AddCol)] { GUudfCollapse $We $rInFo oP }
}
