package provide TclGUI 1.0

proc GUIsymPick { pW vN } {
   global SymDone uSYM

   upvar $vN _V_
   set uSYM "" 

# 03B1 -> 03C9  Lower Case Greek
# 0391 -> 03A9  Upper Case Greek
# 2212 -> 00BE  Math
# 25CF -> End   Geometric Shapes


   set PreSelect [list \
       03B1 03B2 03B3 03B4 03B5 03B6 03B7 03B8 03B9 03BA 03BB 03BC \
       03BD 03BE 03BF 03C0 03C1 03C2 03C3 03C4 03C5 03C6 03C7 03C8 \
       03C9 0391 0392 0393 0394 0395 0396 0397 0398 0399 039A 039B \
       039C 039D 039E 039F 03A0 03A1 03A3 03A4 03A5 03A6 03A7 03A8 \
       03A9 2212 00D7 00F7 2215 00B1 2264 2265 2260 2248 2243 2245 \
       2234 221D 2022 221A 221E 222B 222C 2202 2207 00BC 2153 00BD \
       2154 00BE 25CF 25CB 25A0 25A1 25C0 25C1 25B2 25B3 25B6 25B7 \
       25BC 25BD 25C6 25C7 2721 272D 272B 2220 2720 2756 2664 \
       2190 2191 2192 2193 2194 2195 2196 2197 2198 2199 \
       21D0 21D1 21D2 21D3 21D4 21D5 21D6 21D7 21D8 21D9 \
   ]

   set W  .sC
   set Wa .sC.top
   set Wb .sC.symbols
   set Wc .sC.chooser

   if { [info exists SymDone] } { unset SymDone }

   set LaB "Symbol Picker"
   if [GUIWindow $W $LaB] {

      GUIFrame $Wa -1 grid|0|0|news
      GUIFrame $Wb -1 grid|1|0|w
      GUIFrame $Wc -1 grid|2|0|news

      set Len [llength $PreSelect]
      for { set I 0 } { $I < $Len } { incr I } {
         set R [expr $I / 12 + 1]
         set C [expr $I % 12]
         set SyM \\u[lindex $PreSelect $I]
         set uHex [lindex $PreSelect $I]
         GUIbuttonPush $Wb.b$I $SyM grid|$R|$C "set uSYM \"$SyM : $uHex\"" 8 2
      }

      GUIbuttonPush $Wa.can "CANCEL" grid|0|0|w \
                               "GUIdonePick $pW $W NoPiCk SYMBOL" 4,0
      GUIbuttonPush $Wa.ok "SELECT" grid|0|2|e \
                               "GUIdonePick $pW $W $vN SYMBOL" 4,0
      GUIchgConf $Wa.ok "" "" "" "" raised
      GUIboxEntry $Wa.hex grid|0|1 15 uSYM center [list "" "" bold]

   } else { GUIwindowCtrl $W }

   tkwait variable SymDone
   if { [info exists SymDone] } { unset SymDone }
}
