package provide TclGUI 1.0

proc GUIprefsSet { } {
  global env Prefs 

   set Wt .gStop
   set Wm .gSmain
   set Ww .gSwidgs
   set Wb .gSbot   

   set Fonts [font families]
   set ButtonRel [list flat sunken raised groove ridge ]
   set LDirection [list vertical horizontal]
   set nLb [list 1 2 3]

   font create CleaN -size $Prefs(FontSize) -family fixed

   set Opts [array names Prefs -glob *Label]
   set oLen [llength $Opts]
   for { set I 0 } { $I < $oLen } { incr I } {
      set Indx [lindex $Opts $I]
      set Pos [expr [string first Label $Indx] -1] 
      set iD [string range $Indx 0 $Pos]
      set LiD($I) $iD 
   }

   set Fld [list Rel BgCol FgCol FocCol DisCol MutCol]  
   set fLen [llength $Fld]
   set aNc [list left/left left/center left/right \
                 center/left center/center center/right \
                 right/left right/center right/right ]
   set mWd [list normal small]

   if { [winfo exists $Wt] == 0 } {
      wm title . "Menu Prefs"
 
      GUIFrame $Wt -1 pack|top||both
      GUIFrame $Wm -1 pack|top||both
      GUIFrame $Ww -1 pack|top||both
      GUIFrame $Wb -1 pack|top||both
      GUIFrame $Wm.l 0 pack|left|w|
      GUIFrame $Wm.r 0 pack|left||both

      GUILabel $Wt.title "GUI CONFIGURATION" c pack|left|center|x|true \
        6 30 "" [list "" [expr $Prefs(FontSize) + 6] bold]
  
      GUIbuttonPush $Wt.close QUIT pack|right "exit" 6
      GUIbuttonPush $Wt.write WRITE pack|right "GUIprefsWrite" 6

      set Row 0
      GUILabel $Wm.l.lab$Row "Font Size:" w grid|$Row|0|e 
      GUIboxEntry $Wm.l.fld$Row grid|$Row|1 12 Prefs(FontSize)
      bind  .gSmain.l.fld$Row <Return> { \
          font configure default -size $Prefs(FontSize) ; \
          font configure CleaN -size $Prefs(FontSize)   ; \
          set fL [list fixed [expr $Prefs(FontSize) + 8]] ; \
          .gStop.title configure -font $fL }

      incr Row
      GUILabel $Wm.l.lab$Row "Font:" w grid|$Row|0|e
      GUIbuttonMenu $Wm.l.fld${Row}c1 $Prefs(Font) grid|$Row|1|w $Fonts \
         "GUIReConfig $Wm.l.fld${Row}c1 103 XXX" 6 10 "" "" "" [list CleaN ]

      incr Row
      GUILabel $Wm.l.lab$Row "Frame Border Width:" w grid|$Row|0|e
      GUIboxEntry $Wm.l.fld$Row grid|$Row|1 12 Prefs(FrmBw)
      bind .gSmain.l.fld$Row <Return> "GUIReConfig $Ww.fld${Row}c1 200 F" 

      incr Row
      GUILabel $Wm.l.lab$Row "Option Anchor:" w grid|$Row|0|e
      GUIbuttonMenu $Wm.l.fld${Row}c1 $Prefs(AnC) grid|$Row|1|w $aNc \
            "GUIReConfig $Wm.l.fld${Row}c1 102 M" 6 10 \

      incr Row
      GUILabel $Wm.l.lab$Row "Button Width:" w grid|$Row|0|e
      GUIboxEntry $Wm.l.fld$Row grid|$Row|1 12 Prefs(ButtonW)
      bind .gSmain.l.fld$Row <Return> "GUIReConfig $Wm.fld${Row}c1 200 M ; \ 
                                       GUIReConfig $Wm.fld${Row}c1 200 B  " 

      set Row 0
      GUILabel $Ww.lab${Row}c2 "Background" c grid|$Row|2|news 
      GUILabel $Ww.lab${Row}c3 "Foreground" c grid|$Row|3|news 
      GUILabel $Ww.lab${Row}c4 "Focus" c grid|$Row|4|news 
      GUILabel $Ww.lab${Row}c5 "Disabled" c grid|$Row|5|news 
      GUILabel $Ww.lab${Row}c6 "Muted" c grid|$Row|6|news 
      incr Row
      GUILabel $Ww.lab${Row}c1 "Relief:" c grid|$Row|1|news
      GUILabel $Ww.lab${Row}c2 "Color:" c grid|$Row|2|news
      GUILabel $Ww.lab${Row}c3 "Color:" c grid|$Row|3|news
      GUILabel $Ww.lab${Row}c4 "Color:" c grid|$Row|4|news
      GUILabel $Ww.lab${Row}c5 "Color:" c grid|$Row|5|news
      GUILabel $Ww.lab${Row}c6 "Color:" c grid|$Row|6|news

      set CTmP $Prefs(BBgCol)
      incr Row

      set PrefNames [array names Prefs]

      for { set nL 0 } { $nL < $oLen } { incr nL ; incr Row } {
         set iD $LiD($nL)
         GUILabel $Ww.lab$Row $Prefs(${iD}Label) w grid|$Row|0|e
         GUIbuttonMenu $Ww.fld${Row}c1 $Prefs(${iD}Rel) \
                 grid|$Row|1|w $ButtonRel \
                 "GUIReConfig $Ww.fld${Row}c1 ${iD}Rel $iD" 6 10

         set I 1
         for { set Col 2 } { $I < $fLen} { incr Col ; incr I } {
            set Field [lindex $Fld $I]
            set Prefs(BBgCol) $Prefs(${iD}${Field})

            set cW $Ww.fld${Row}c$Col
            GUIbuttonPush $cW "" grid|$Row|$Col \
	                       "GUIcolorPick $cW Prefs(${iD}$Field)" 6 10
         }

         set Prefs(BBgCol) $CTmP
      }


   } else { wm deiconify $W }
}
