package provide TclGUI 1.0

proc GUImenuFill { W Ops Cmd Init sZ { mFonT "" } { mColor "" } } {
   global env Prefs GUIoptAlts

   set Wm $W.menu

   if [info exists Prefs(bFit)] { set bFit $Prefs(bFit) } else { set bFit 0 }

   set iC [string match NEW $Init] 

   set oLen [llength $Ops ]
   set cLen [llength $mColor]
   set fLen [llength $mFonT]
   if { $fLen > $oLen } { set fLen $oLen }
   if { $cLen > $oLen } { set cLen $oLen }

   if { $fLen == 0 } { 
       set mHold 1 
       set fLen 1
   } else { set mHold [expr $oLen / $fLen ] } 
   if { $cLen == 0 } { 
       set cHold 1 
       set cLen 1 
       set mColor $Prefs(MFgCol)
   } else { set cHold [expr $oLen / $cLen ] } 

# NO menu widget or no options then nothing to do

   if { ![winfo exist $Wm] || ($oLen == 0) } { return }

# IF NEW then delete all of the current menu options, clear the 
#   alternate option settings and point option index 0, otherwise
#   just point to the next available index

   if $iC { 
      $Wm delete 0 end 
      set GUIoptAlts($W) ""
      set nE 0
   } else { set nE [expr [$Wm index end] + 1] }
   
# GET the option alternates into their holding array

   set oPs ""
   set aI $nE
   for { set I 0 } { $I < $oLen } { incr I ; incr aI } {
      set oPt [split [lindex $Ops $I ] '|']
      lappend oPs [lindex $oPt 0]
      if { [llength $oPt] > 1 } { 
         lappend GUIoptAlts($W) [lindex $oPt 1] 
      } else { lappend GUIoptAlts($W) $aI }
   }

# IF sZ is not 0 then we get to set the size of the menu otherwise the GUI
#   manager can take care of it.  
   
   if { $sZ != 0 } { 
      set mX 0

# IF bFit is 0 then we are going to set the width to the largest option
#   length + 2

      if !$bFit {
         for { set I 0 } { $I < $oLen } { incr I } {
           set sL [string length [lindex $oPs $I] ]
           if { $sL > $mX } { set mX  $sL}
         }
         incr mX 2
      } else {

# Otherwise we will try to get a best fit to the actual option

         set mF [lindex $mFonT 0]
	 GUImakeFont mF
         set bL [expr [font measure $mF "abCDEf"] / 6]
         for { set I 0 } { $I < $oLen } { incr I } {
           set sL [font measure $mF [lindex $oPs $I]]
           if { $sL > $mX } { set mX  $sL}
         }
         set mX [expr $mX / $bL + 2] 
      }
      if { $mX > $sZ } {
         $W configure -width $mX
      } else { $W configure -width $sZ }
   } 

   set bV [GUImenuCLen $oLen]
   for { set I 0 } { $I < $oLen } { incr I ; incr nE } {
      set Option [lindex $oPs $I]
      set CmD "$Cmd $nE"
      set J [expr int($I / $mHold)]
      if { $J >= $fLen } { set J [expr $fLen - 1] }
      set mF [lindex $mFonT $J]
      GUImakeFont mF
      set J [expr int($I / $cHold)]
      if { $J >= $cLen } { set J [expr $cLen - 1] }
      set mC [lindex $mColor $J]

      if {[expr $nE % $bV] == 0} {
          $Wm add command -label $Option -font $mF -foreground $mC \
              -columnbreak 1 -command "$CmD"
      } else {
         $Wm add command -label $Option -font $mF -foreground $mC \
	     -command "$CmD"
      }
   }
}
