# THE Geometry manager input is a list with elements
#   
#   Index 0  Geometry manager  grid          | pack      | place  
#   Index 1                    row number    | side      | parent 
#   Index 2                    column number | anchor    | anchor   
#   Index 3                    sticky        | fill      | relx 
#   Index 4                    row span      | expand    | rely   
#   Index 5                    column span   | ipadx     | absx 
#   Index 6                    ipadx         | ipady     | absy  
#   Index 7                    ipady         | padx      |  
#   Index 8                    padx          | pady      |  
#   Index 9                    pady          | in        |
#   Index 10                   in            | before    |
#   Index 11                                 | after     |   

package provide TclGUI 1.0 
proc GUIgeoManage { W gM } {  

   global env Prefs

   set gM [split $gM "|"]
   switch -exact -- [lindex $gM 0] {
      grid {
         set dF [list grid 0 0 news 1 1 0 0 0 0 ""]
	 set nE [llength $dF]
         for { set I 0 } { $I < $nE } { incr I } { set oP($I) [lindex $gM $I] }
         for { set I 1 } { $I < $nE } { incr I } { 
            if { [string length $oP($I)] == 0 } { set oP($I) [lindex $dF $I] }
         }

	 if [string match center $oP(3)] { set oP(3) {} }

         grid $W -row $oP(1) -column $oP(2) \
                  -columnspan $oP(5) -rowspan $oP(4) \
                  -sticky $oP(3) \
                  -ipadx $oP(6) -ipady $oP(7) \
                  -padx $oP(8) -pady $oP(9)

         if { [string length $oP(10)] > 0 } { 
            grid configure $W -in $oP(10) 
         }
      }
      pack {
         set dF [list pack top center none false 0 0 0 0 "" "" ""]
	 set nE [llength $dF]
         for { set I 0 } { $I < $nE } { incr I } { set oP($I) [lindex $gM $I] }
         for { set I 1 } { $I < $nE } { incr I } { 
            if { [string length $oP($I)] == 0 } { set oP($I) [lindex $dF $I] }
         }

         pack $W -side $oP(1) -anchor $oP(2) \
                  -fill $oP(3) -expand $oP(4) \
                  -ipadx $oP(5) -ipady $oP(6) \
                  -padx $oP(7) -pady $oP(8)

         if { [string length $oP(9)] > 0 } { 
            pack configure $W -in $oP(9) 
         }
         if { [string length $oP(10)] > 0 } { 
            pack configure $W -before $oP(10) 
         }
         if { [string length $oP(11)] > 0 } { 
            pack configure $W -after $oP(11) 
         }
      }
      place {
         set dF [list place "" center .5 .5 "" ""]
	 set nE [llength $dF]
         for { set I 0 } { $I < $nE } { incr I } { set oP($I) [lindex $gM $I] }
         for { set I 1 } { $I < $nE } { incr I } { 
            if { [string length $oP($I)] == 0 } { set oP($I) [lindex $dF $I] }
         }

         if { [string length $oP(1)] == 0 } { return }
      }
   }
}
