package provide TclGUI 1.0

proc GUIboxText { W  X  Y  gM  { xS 0 } { yS 0 } { FonT "" } { Wrap "" } } {
   global env Prefs

# NEED to determine the base window name 

   set bN [split $W "."]
   set wL [llength $bN]
   set EnD [expr $wL - 1]
   set bW .[lindex $bN 1]
   for { set I 2 } { $I < $EnD } { incr I } { append bW ".[lindex $bN $I]" } 

# Process font information

   GUImakeFont FonT

# IF there are scroll bars then set them up now

   if { $xS == 1 } {
      scrollbar $bW.xscroll -orient horizontal \
                      -troughcolor $Prefs(SBgCol) \
                      -background $Prefs(SFgCol) \
                      -activebackground $Prefs(SFocCol) \
                      -command [list $W xview]
   }

   if { $yS == 1 } {
      scrollbar $bW.yscroll -orient vertical \
                      -troughcolor $Prefs(SBgCol) \
                      -background $Prefs(SFgCol) \
                      -activebackground $Prefs(SFocCol) \
                      -command [list $W yview]
   }

# NOW set up the text box according to what (if any) scroll bars are to be
#   added to it

   if { ($xS == 0) && ($yS == 0) } {
      text $W -relief $Prefs(TRel) -font $FonT \
              -background $Prefs(TBBgCol) -foreground $Prefs(TBFgCol) 
   } elseif { ($xS == 1) && ($yS == 1) } {
      text $W -relief $Prefs(TRel) -font $FonT \
              -xscrollcommand [list $bW.xscroll set] \
              -yscrollcommand [list $bW.yscroll set] \
              -background $Prefs(TBBgCol) -foreground $Prefs(TBFgCol) 
   } elseif { ($xS == 1) } {
      text $W -relief $Prefs(TRel) -font $FonT \
              -xscrollcommand [list $bW.xscroll set] \
              -background $Prefs(TBBgCol) -foreground $Prefs(TBFgCol) 
   } else {
      text $W -relief $Prefs(TRel) -font $FonT \
              -yscrollcommand [list $bW.yscroll set] \
              -background $Prefs(TBBgCol) -foreground $Prefs(TBFgCol) 
   }

# ADD any window sizing

   if { $X > 0 } { $W configure -width $X  }
   if { $Y > 0 } { $W configure -height $Y }

# ADD the widget 

   GUIgeoManage $W $gM

# NOW pack up the scroll bars if any defined

   set gMs [split $gM "|"]
   if [string match pack [lindex $gMs 0]] {
      if { $yS == 1 } { pack $W $bW.yscroll -side left -fill y }
      if { $xS == 1 } { grid $W $bW.xscroll -side left -fill x }
   } else {
      set RoW [lindex $gMs 1]
      set CoL [lindex $gMs 2]
      set gLen [llength $gMs]
      set rS [lindex $gMs 4]
      set cS [lindex $gMs 5]
      if { [string length $rS] == 0 } { set rS 1 }
      if { [string length $cS] == 0 } { set cS 1 }
      if { $yS == 1 } {
          grid $bW.yscroll -sticky nsw -column [expr $CoL + $cS] \
                           -row $RoW -rowspan $rS
      }
      if { $xS == 1 } {
          grid $bW.xscroll -sticky nsw -row [expr $RoW + $rS] \
                           -column $CoL -columnspan $cS
      }
      grid rowconfigure $W 0 -weight 1
      grid columnconfigure $W 0 -weight 1
   }

   if { [string length $Wrap] > 0 } { $W configure -wrap $Wrap }
}
