package provide TclGUI 1.0

proc GUIboxList { W  X  Y gM  Cmd  { SMode single } { xS 0 } { yS 1 } \
                  { FonT "" }} {
   global env Prefs

# NEED to determine the base window name
                                                                                
   set bN [split $W "."]
   set wL [llength $bN]
   set EnD [expr $wL - 1]
   set bW .[lindex $bN 1]
   for { set I 2 } { $I < $EnD } { incr I } { append bW ".[lindex $bN $I]" }

   if { $xS == 1 } {
      scrollbar $bW.xscroll -orient horizontal \
                      -troughcolor $Prefs(SBgCol) \
                      -background $Prefs(SFgCol) \
                      -activebackground $Prefs(SFocCol) \
                      -command [list $W xview]
   }
                                                                                
   if { $yS == 1 } {
      scrollbar $bW.yscroll -orient vertical \
                      -troughcolor $Prefs(SBgCol) \
                      -background $Prefs(SFgCol) \
                      -activebackground $Prefs(SFocCol) \
                      -command [list $W yview]
   }

   GUImakeFont FonT
   if { ($xS == 0) && ($yS == 0) } {
      listbox $W -font $FonT -relief $Prefs(LBRel) \
           -selectmode $SMode -fg $Prefs(LBFgCol) \
	   -disabledforeground $Prefs(LBFgCol) \
           -bg $Prefs(LBBgCol) -selectbackground $Prefs(LBFocCol)
   } elseif { ($xS == 1) && ($yS == 1) } {
      listbox $W -font $FonT -relief $Prefs(LBRel) \
            -xscrollcommand [list $bW.xscroll set] \
            -yscrollcommand [list $bW.yscroll set] \
            -selectmode $SMode -selectbackground $Prefs(LBFocCol) \
	   -disabledforeground $Prefs(LBFgCol) \
            -fg $Prefs(LBFgCol) -bg $Prefs(LBBgCol)
   } elseif { ($xS == 1) } {
      listbox $W -font $FonT -relief $Prefs(LBRel) \
            -xscrollcommand [list $bW.xscroll set] \
            -selectmode $SMode -selectbackground $Prefs(LBFocCol) \
	   -disabledforeground $Prefs(LBFgCol) \
            -fg $Prefs(LBFgCol) -bg $Prefs(LBBgCol)
   } else {
      listbox $W -font $FonT -relief $Prefs(LBRel) \
            -yscrollcommand [list $bW.yscroll set] \
            -selectmode $SMode -selectbackground $Prefs(LBFocCol) \
	   -disabledforeground $Prefs(LBFgCol) \
            -fg $Prefs(LBFgCol) -bg $Prefs(LBBgCol)
   }

# ADD any window sizing
                                                                                
   if { $X > 0 } { $W configure -width $X  }
   if { $Y > 0 } { $W configure -height $Y }

# ADD the widget
                                                                                
   GUIgeoManage $W $gM
                                                                                
# NOW pack up the scroll bars if any defined.  Need to use pack if box was
#   packed and grid otherwise.

   set gMs [split $gM "|"]
   if [string match pack [lindex $gMs 0]] {
      if { $yS == 1 } { pack $W $bW.yscroll -side left -fill y }
      if { $xS == 1 } { grid $W $bW.xscroll -side left -fill x }
   } else {
      set RoW [lindex $gMs 1]
      set CoL [lindex $gMs 2]
      set gLen [llength $gMs]
      set rS [lindex $gMs 4]
      set cS [lindex $gMs 5]
      if { [string length $rS] == 0 } { set rS 1 }
      if { [string length $cS] == 0 } { set cS 1 }
      if { $yS == 1 } { 
          grid $bW.yscroll -sticky nws -column [expr $CoL + $cS] \
                           -row $RoW -rowspan $rS
      }
      if { $xS == 1 } { 
          grid $bW.xscroll -sticky nws -row [expr $RoW + $rS] \
                           -column $CoL -columnspan $cS
      }
      grid rowconfigure $W 0 -weight 1
      grid columnconfigure $W 0 -weight 1
   }

# ADD the mouse binding for selecting items

   if { [string length Cmd] > 0 } { bind $W <ButtonRelease-1> $Cmd }
}
