# This routine computes the new output positions when there is a mixture
#    of fonts being used in a label

package provide GPUtils 1.0

proc GPUalignText { tLab tInfo } {
   global RtoD

   upvar $tInfo tI

# GET the text X alignment which is found in the last line of the text
#   block

   set xA [format "%.1f" [lindex $tI(LEnd) 2]]

# GET the text X and Y position of the text which found in the position line
#   of the text block.  In Tk versions < 8.6 this is the first two values
#   while in versions >= 8.6 this is the first and second values in the line.
#   The first value is the text angle and the text is rotatable.

   if $tI(Rotate) {
      set aP [lindex $tI(Pos) 0]
      set xP [lindex $tI(Pos) 1]
      set yP [lindex $tI(Pos) 2]
      set rX [expr cos($aP / $RtoD)]
      set rY [expr sin($aP / $RtoD)]
   } else {
      set xP [lindex $tI(Pos) 0]
      set yP [lindex $tI(Pos) 1]
      set rX 1.0
      set rY 0.0
   }

# GET the number of blocks which are being output.  If there is only one
#   then we don't have to adjust the alignment

   set nS [llength $tLab]
   if { $nS == 1 } { return [list [list $aP $xP $yP]] }
   set tnS [expr $nS - 1]

# THERE are multiple blocks so some adjustment needs to occur

# INITIALIZE sOffs the returned label X Y position list, nT the total 
#   string length and tL a list holding the the length of the each 
#   component in the string.

   set sOffs ""
   set nT 0
   set tL ""

# LOOP over the blocks and compute the relative length of each component
#   in the string.

   for { set I 0 } { $I < $nS } { incr I } {
      set lType [lindex [lindex $tLab $I] 0]
      set Lab [lindex [lindex $tLab $I] 1]
      set TSz [expr [lindex $tI($lType) 2] - 1]
      if { $TSz < 4 } { set TSz 4 }
      set nL [llength $Lab]

      if [string match V $tI(Dir)] {
	 if { $I == $tnS } {
	    set tLen [expr $nL * $TSz] 
	 } else { set tLen [expr $nL * $TSz] } 
      } else { set tLen [GPUtextLen [lindex $Lab 0] $TSz $lType] }

      set nT [expr $nT + $tLen]
      lappend tL $tLen
   }
   lappend tL $tLen

# Adjust the output position of each separate string being output in the
#   text.  Adjustments are done differently for horizontal and vertical 
#   text.

   if [string match H $tI(Dir)] {
      switch -exact -- $xA {
          0.0 -
         -0.0 {
	    set tC 0
            set xO $xP
            set yO $yP

            for { set I 0 } { $I < $nS } { incr I } {
               set lType [lindex [lindex $tLab $I] 0]
               if [string match S $lType] { 
                  set xO [expr $xO + 5.5 * $rY]
                  set yO [expr $yO - 5.5 * $rX]
               }
               if $tI(Rotate) {
                  lappend sOffs [list $aP $xO $yO]
               } else { lappend sOffs [list $xO $yO] }
               set tC [lindex $tL $I]
               set xO [expr $xO + $tC * $rX]
               set xO [expr $xO + $tC * $rY]
               if [string match S $lType] { 
                  set xO [expr $xO - 5.5 * $rY]
                  set yO [expr $yO + 5.5 * $rX]
	       }
            }
         }
         -0.5 {
	    set tC 0
            set xO [expr $xP - $rX * $nT / 2]
            set yO [expr $yP - $rY * $nT / 2]
	    set tC [expr [lindex $tL 0] / 2]
            for { set I 0 ; set J 1 } { $I < $nS } { incr I ; incr J } {
               set lType [lindex [lindex $tLab $I] 0]
               if [string match S $lType] { 
                  set xO [expr $xO + 5.5 * $rY]
                  set yO [expr $yO - 5.5 * $rX]
               }
	       set xO [expr $xO + $tC * $rX]
	       set yO [expr $yO + $tC * $rY]
               set tC [expr ([lindex $tL $I] + [lindex $tL $J]) / 2 ]
               if $tI(Rotate) {
                  lappend sOffs [list $aP $xO $yO]
               } else { lappend sOffs [list $xO $yO] }
               if [string match S $lType] { 
                  set xO [expr $xO - 5.5 * $rY]
                  set yO [expr $yO + 5.5 * $rX]
               }
            }
         }
         -1.0 {
	    set tC 0
            set xO [expr $xP - $rX * $nT]
            set yO [expr $yP - $rY * $nT]

            for { set I 0 } { $I < $nS } { incr I } {
               set lType [lindex [lindex $tLab $I] 0]
               set tC [lindex $tL $I]
               set xO [expr int($base + $tC)]
               set base [expr $base + $tC]
               if [string match S $lType] { 
                  set xO [expr $xO + 5.5 * $rY]
                  set yO [expr $yO - 5.5 * $rX]
               }
               if $tI(Rotate) {
                  lappend sOffs [list $aP $xO $yO]
               } else { lappend sOffs [list $xO $yO] }
               set tC [lindex $tL $I]
               set xO [expr $xO + $tC * $rX]
               set xO [expr $xO + $tC * $rY]
               if [string match S $lType] { 
                  set xO [expr $xO - 5.5 * $rY]
                  set yO [expr $yO + 5.5 * $rX]
               }
            }
         }
      }
   } else { 
      set vS 4.0
      switch -exact -- $xA {
         -0.5 {
            set MiD [expr ($nT + ($nS - 1) * $vS)  / 2.0]
            set base [expr $yP + $MiD]
	    set xO $xP

            for { set I 0 } { $I < $nS } { incr I } {
               set lType [lindex [lindex $tLab $I] 0]
               set tC [expr [lindex $tL $I] * 1.0]
               set yO [expr int($base - $tC / 2.0)]
               set base [expr $base - $tC - $vS]
               if [string match S $lType] { 
                  set yO [expr int($yO - 5)] 
               } 
               if $tI(Rotate) {
                  lappend sOffs [list $aP $xO $yO]
               } else { lappend sOffs [list $xO $yO] }
            }
         }
      }
   } 
   return $sOffs
}
