package provide GPUtils 1.0

proc GPUaddText { fo tInfo LaBs } {
   upvar $tInfo tI

   set tC 0

# DETERMINE if this is a horizontal or vertical label

   set nL [llength $LaBs]
   if { $nL == 1 } { set tI(Dir) H } else { set tI(Dir) V }

# SPLIT the label into its components

   set pLabs [GPUsplitText $LaBs] 

# THIS is the number of components

   set nLP [llength $pLabs]

# SHIFT components when a label makes use of multiple fonts.  tOff is
#   a list of the new label X and Y position to use for each component
#   of a label.

   set tOff [GPUalignText $pLabs tI]

# NOW reassemble the postscript label block

   for { set L 0 } { $L < $nLP } { incr L } {

# GET the font type and the position for this part of the text

      set lType [lindex [lindex $pLabs $L] 0]

# REFORM the position line
 
      set sOff [lindex $tOff $L]
      if $tI(Rotate) {
         set tI(Pos) "[lindex $sOff 0] [lindex $sOff 1] [lindex $sOff 2] \["
      } else { set tI(Pos) "[lindex $sOff 0] [lindex $sOff 1] \[" }

# THIS is the number of strings in this label

      set lStr [lindex [lindex $pLabs $L] 1]
      set lL [llength $lStr]

# ADD the first three lines of the label block to the output file.  This is
#   up to the point where the label gets added.  If this is part of a multiple
#   block label need to start it with a gsave command.

      if { $L > 0 } { puts $fo "gsave" }
      puts $fo $tI($lType)
      puts $fo $tI(Color)
      puts $fo $tI(Pos)

# ADD the label

      for { set K 0 } { $K < $lL } { incr K } {
         set LaB  [lindex $lStr $K]
         puts $fo $LaB
      }

# ADD the last line of the label block and the grestore command.

      puts $fo $tI(LEnd)
      puts $fo "grestore"
   }
}
