# Determine the width of the text to be output

package provide GPUtils 1.0

proc GPUtextLen { Lab Sz tType} {
   global GPUHelvSz GPUDingSz GPUSymSz 

# NORMALIZE the character width to the text size of to a capitol M

   set cH M
   scan $cH "%c" mIndex
   set Fac [expr $Sz / $GPUHelvSz($mIndex)]

# INITIALIZE the 
   set tL 0

# SORT through the text based on the font type if the text

   switch -exact -- $tType {
      A { 
         set nC [expr [string length $Lab] - 2]
         for { set I 2 } { $I < $nC } { incr I } {
            set cH [string index $Lab  $I]
            scan $cH "%c" Index
	    if { $Index == 92 } {
	       set octal [string range $Lab [expr $I + 1] [expr $I + 3]]
	       set Index [format "%i" $octal] 
	       incr I 3
            } 
	    if [info exist GPUHelvSz($Index)] {
               set tL [expr $tL + $GPUHelvSz($Index) * $Fac]
            } else { set tL [expr $tL + $GPUHelvSz($mIndex) * $Fac] }
         }
      }
      D { 
         set nC [expr [string length $Lab] - 2]
         for { set I 2 } { $I < $nC } { incr I } {
            set cH [string index $Lab  $I]
            scan $cH "%c" Index
	    if [info exist GPUDingSz($Index)] {
               set tL [expr $tL + $GPUDingSz($Index) * $Fac]
            } else { set tL [expr $tL + $GPUHelvSz($mIndex) * $Fac] }
         }
      }
      S { 
         set eLab [expr [string length $Lab] - 2]
         set nLab [string range $Lab 1 $eLab]
         set Syms [split $nLab "/"]
         set nS [llength $Syms]

         for {set I 0} { $I < $nS} { incr I } {
	    set Glyph [lindex $Syms $I] 
	    if { [string length $Glyph] > 0 } {
	       if [info exist GPUSymSz($Glyph)] {
                  set tL [expr $tL + $GPUSymSz($Glyph) * $Fac]
               } else { set tL [expr $tL + $GPUHelvSz($mIndex) * $Fac] }
	    }
	 }
      }
   }

   return $tL
}
