# THIS routine looks at a label and separates out the ASCCI, Symbol,
#   and Dingbat fonts in it.

package provide GPUtils 1.0

proc GPUsplitText { tLab } {
   global GPUDingTr

# INITIALIZE the output label list

   set Labs ""

# FIND out how many labels there are in the label block.  Multiple labels 
#    mean vertical text

   set nL [llength $tLab]

# INITIALIZE TmPLaB which contains the various text associated with
#   different fonts.  For vertical labels each element in TmPLaB will
#   constitute a diffent line.

   set TmPLaB ""

# LOOP over the different lines in the label.  With vertical labels there
#   is only one character per line

   for { set J 0 } { $J < $nL } { incr J } {

# GET the text

      set Text [lindex $tLab $J]

# THIS is the location of the last character in the text

      set eTxT [expr [string length $Text] - 2]

# THIS is the text less the brakets

      set nTxT [string range $Text 1 $eTxT]

# SPLIT text against Symbol and Dingbat glyphs and then see how many
#   sections of text there are

      set sT [split $nTxT "/"]
      set nT [llength $sT]

# Quick check against single /

      if { ([string length $sT] == 3) && ($nT == 2) } {
         set nT 1
	 set sT "(/)"
      }

# LOOP over the different sections of text

      for {set I 0} { $I < $nT} { incr I } {

# THIS is the text to work with

         set TxT [lindex $sT $I]

# MAKE sure that there is something there

         if { [string length $TxT] > 0 } {

# FIND the location of the first ( if there is one.  IF there is then
#   find the location of the )

            set oP [string first "(" $TxT]
            if { $oP >= 0 } { set cP [string first ")" $TxT] }

# IF there is a leading ( then this is an ascii string of text

            if { $oP == 0 } {
               lappend TmPLaB [list A $TxT]

# IF there is a non-leading ( then strip out the text up to the ( and
#   check to see if its a Dingbat glyph.  If not then its a Symbol glyph.

            } elseif { $oP > 0 } {
	       set lC [expr $oP - 1]
	       set tTxT [string range $TxT 0 $lC]
               set rV [GPUnameChk $tTxT]
	       if [string match D $rV] {
	           lappend TmPLaB [list D "$GPUDingTr($tTxT)"]
               } else { lappend TmPLaB [list $rV "/$tTxT"] }

# Whats between the () in the text will be ascii text

	       set tStr [string range $TxT $oP $cP]
	       if { [string length $tStr] > 2 } {
	          lappend TmPLaB [list A $tStr]
               }
	    } else { 

# IF there was no ( then the text is pure Dingbat or Symbol

               set rV [GPUnameChk $TxT]
	       if [string match D $rV] {
	           lappend TmPLaB [list D "$GPUDingTr($TxT)"]
               } else { lappend TmPLaB [list $rV "/$TxT"] }
            }
         } 
      }
   }

# REFORM the label. There is a difference between doing this for horizontal 
#   and vertical labels.  For horizontal labels of common successive font 
#   types are combined into a common text string while with vertical labels
#   they stay as individual strings. 

   set Labs ""
   set nT [expr [llength $TmPLaB] - 1]

   if { $nL == 1 } {
      for { set I 0 } { $I <= $nT } { } {
         set lType [lindex [lindex $TmPLaB $I] 0]
         set TmPTxT [lindex [lindex $TmPLaB $I] 1]

         incr I 
         while { $I <= $nT } {
            if [string match $lType [lindex [lindex $TmPLaB $I] 0]] {
               append TmPTxT [lindex [lindex $TmPLaB $I] 1]
	       incr I
            } else { break }
         }

         if [string match D $lType] {
            lappend Labs [list $lType [list \[\($TmPTxT\)\]]]
         } else { lappend Labs [list $lType [list \[$TmPTxT\]]] }
      }
   } else {
      set TmPTxT ""

# Get the proper enclosure around all the text characters up front

      for { set I 0 } { $I <= $nT } { incr I } {
         set lType [lindex [lindex $TmPLaB $I] 0]
         set Ch  [lindex [lindex $TmPLaB $I] 1]
         if [string match D $lType] { 
	     set tStr \[\($Ch\)\]
         } else { set tStr \[$Ch\] }
         lappend Labs [list $lType $tStr]
      }
   }

   return $Labs
}
