# THIS is the postscript conversion procedure which reads the file, does
#   the necessary changes, and outputs a corrected file.

package provide GPUtils 1.0

proc GPUreadPSfile { NLineOps LineOps } {

# Initialize text rotation to NO.  It will change if the DrawText statement
#    allows rotation
 
   set tI(Rotate) 0

# The first and second line opitions are the input and output file names. 
#   Open these files now.  The output file is opened in binary mode.

   set iFile [lindex $LineOps 0]
   set oFile [lindex $LineOps 1]
   set fi [open $iFile r]
   set fo [open $oFile w]
   fconfigure $fo -translation binary

# The third option specifies any correction to the Helvetica character 
#   size found in the poststript file. Positive value increases the character 
#   size and nositive value decreases it.
  
   set IncHs [lindex $LineOps 2]

# The fourth option specifies any correction to the Symbol character 
#   size found in the poststript file. Positive value increases the character 
#   size and nositive value decreases it.
  
   set IncSs [lindex $LineOps 3]

# The fifth option specifies any correction to the Dingbat character 
#   size found in the poststript file. Positive value increases the character 
#   size and nositive value decreases it.
  
   set IncDs [lindex $LineOps 4]

# The sixth option specifies a correction to the line with.  Positive values 
#   increases the line width and nogitive values decrease it.
  
   set IncLw [lindex $LineOps 5]


# READ in the postscript file.  We are looking for text output blocks and
#   linewidth sets.  The first line of a block will have the word findfont 
#   in it.

   while  { [gets $fi LiNe] >= 0 } {

# CHECK for setlinewidth in line

      set pos [string first setlinewidth $LiNe]
      if { $pos >= 0 } {
         scan $LiNe "%d %s" Lw TmP
	 incr Lw $IncLw
	 set RepLine "$Lw $TmP"
         puts $fo $RepLine
      } else {

# CHECK for findfont in line

         set pos [string first findfont $LiNe]

# IF pos is >= zero then this is the start of a label block.  If its not
#   the start then output the line directly into the new postscript file.

         if { $pos >= 0 } {

# SPLIT the line up into its components

            set sPL [split $LiNe]
            set nE [llength $sPL]

# THE third entry on the line is the text size.  Get it and modify it.  Do
#   mods for all fonts since we don't know what font this text will end up
#   using

            set tS [lindex $sPL 2]

# NOW recreate the line for all fonts.  Dingbat fonts as we will use them
#   are not isoencoded.

            set tI(A) "[lindex $sPL 0] [lindex $sPL 1] [expr $tS + $IncHs]"
            set tI(S) "/Symbol [lindex $sPL 1] [expr $tS + $IncSs]"
            set tI(D) "/Dingbats [lindex $sPL 1] [expr $tS + $IncDs]"
            for { set I 3 } { $I < $nE } { incr I } {
               append tI(A) " [lindex $sPL $I]"
               append tI(S) " [lindex $sPL $I]"
	       if ![string match ISOEncode [lindex $sPL $I]] {
                  append tI(D) " [lindex $sPL $I]"
               }
            }

# READ the next two lines which are the label color and the label
#    text position.

            set EOF [gets $fi tI(Color)]
            set EOF [gets $fi P]

            set tI(Pos) $P

# NULL out label variable

            set LaB ""

# NOW get the label and the closing line of the label command.  The label
#   can encompass multiple line.  The line which contains a ] is the end
#   end of the label block.  The label has ended on the line above.

            while  { [gets $fi LiNe] >= 0 } {
	       set fC [string index $LiNe 0]
	       if  [string match "]" $fC] { 
	          set tI(LEnd) $LiNe
	          break
               } else { lappend LaB $LiNe }
            }

# GET rid of the grestore command.  We'll add it back later

            set EOF [gets $fi TmP]

# ADD the text to the PS file

            GPUaddText $fo tI $LaB

         } else { 

# IF this is the DrawText definition see if its rotateable. If so note that
 
            set PosA [string first "/\DrawText" $LiNe]
	    set PosB [string first "rotate" $LiNe]
	    if { ($PosA == 0) && ($PosB > 0) } { set tI(Rotate) 1 }
	    puts $fo $LiNe
	 }
      } 
   }

# CLOSE both the input and output files.

   close $fi
   close $fo
}
