package provide TclGPH 1.0

proc VtkText { Just TexT Ang } {
   global WinInfo GphInfo XYZ DevCt GPHRender

# SET up the screen designation and get plot canvas

   set wN $GphInfo(curWin)

   if [info exist GphInfo(VtkText)] {
      incr GphInfo(VtkText)
   } else { set GphInfo(VtkText) 0 }
   set iD $GphInfo(VtkText)

   if { $WinInfo($wN,Clip) > 0 } {
      if { [GPHlineClip 0] == 0 } { return }
      set X [expr $XYZ(0)]
      set Y [expr $XYZ(1)]
   } else {
      set X [expr $XYZ(0) * $WinInfo($wN,s0) + $WinInfo($wN,i0)] 
      set Y [expr $XYZ(1) * $WinInfo($wN,s1) + $WinInfo($wN,i1)] 
   }

   set tX [font measure "Courier $GphInfo(tSize)" $TexT]
   if { $WinInfo($wN,Dimen) == 3 } {
      set rX [lindex $Ang 0]
      set rY [lindex $Ang 1]
      set rZ [lindex $Ang 2]
      set Z [expr $XYZ(2) * $WinInfo($wN,s2) + $WinInfo($wN,i2)] 
      switch -exact -- $Just {
         right   { set J Right }
         center  { set J Centered ; set Y [expr $Y - 0.72 * $tX/2.0] } 
         left    { set J Left ; set Y [expr $Y - 0.72 * $tX] } 
         default { set J Centered ; set Y [expr $Y - 0.72 * $tX/2.0] } 
      }

      set tY [font measure "Courier $GphInfo(tSize)" 5]
      set X [expr $X + 0.6  *  $tY/2.0]

   } else { 
       set Z 0.0 ; 
       set rX 0.0
       set rY 0.0
       set rZ [lindex $Ang 2] 
       switch -exact -- $Just {
          right   { set J Right }
          center  { set J Centered ; set X [expr $X - 0.75 * $tX/2.0] } 
          left    { set J Left ; set X [expr $X - 0.72 * $tX] } 
          default { set J Centered ; set X [expr $X - 0.75 * $tX/2.0] } 
       }

       set tY [font measure "Courier $GphInfo(tSize)" 5]
       set Y [expr $Y - 0.6  *  $tY/2.0]
   }


# GET the color components

   VtkFormColor $GphInfo(tColor) RGB

#  vtkTextActor TextActor$iD
#     TextActor$iD SetInput $TexT
#     TextActor$iD SetDisplayPosition $X $Y
#     TextActor$iD ScaledTextOff
#     set tProp [TextActor$iD GetTextProperty]
#     $tProp SetColor $R $G $B
#     $tProp SetFontSize $GphInfo(tSize)
#     $tProp SetJustificationTo$J
#     $tProp SetOrientation $Ang
#     if [string match bold $GphInfo(tBold)] { $tProp BoldOn }
#     if [string match italic $GphInfo(tItalics)] { $tProp ItalicOn }
#     $tProp SetFontFamilyToArial

   if { ($WinInfo($wN,Dimen) == 3) && [string match UP $GphInfo(3Dz)] } {
      set TmP $X 
      set X $Y 
      set Y $Z 
      set Z $TmP 
   }

   vtkTextActor3D TextActor$iD
      TextActor$iD SetInput $TexT
      TextActor$iD SetPosition $X $Y $Z
      TextActor$iD SetOrientation $rX $rY $rZ
      set tProp [TextActor$iD GetTextProperty]
      $tProp SetColor $RGB(0) $RGB(1) $RGB(2)
      $tProp SetFontSize $GphInfo(tSize)

      $tProp SetJustificationTo$J
      $tProp SetVerticalJustificationToCentered
      $tProp SetFontFamilyToCourier
      $tProp ShadowOff
      if [string match bold $GphInfo(tBold)] { $tProp BoldOn }
      if [string match italic $GphInfo(tItalics)] { $tProp ItalicOn }

# ADD to the render

   GPHRender AddActor TextActor$iD
}
